# testURI.rb: testcases for JaUtils::URI

require 'test/unit'
load 'blazer-ja-proxy'

require 'uri'

class TestURI < Test::Unit::TestCase

	def test_canonical
		{
			'http://mail.google.com/mail/?view=page&name=js' => 'http://mail.google.com/mail/',
			'http://news.google.co.jp/' => 'http://news.google.co.jp/',
			'http://hoge:muga@news.google.co.jp/' => nil,
		}.each_pair do |uri, canonical|
			assert_equal(canonical, BlazerProxy::canonical_url(URI::parse(uri)))
		end
	end

end
