%define __check_files %{nil}

%define _with_smtps 1
%define with_smtps %{?_with_smtps:1}%{!?_with_smtps:0}

%define vendor_openssl %([ "%{?_vendor_openssl}" = "" ] && echo || echo %{_vendor_openssl})
%define vendor_libdir %([ "%{?_vendor_libdir}" = "" ] && echo || echo %{_vendor_libdir})
%define vendor_includedir %([ "%{?_vendor_includedir}" = "" ] && echo || echo %{_vendor_includedir})

%define version 1.0.0
%define release 2
%define _libdir /lib

Summary: A Pluggable Authentication Module for SMTP Authentication.
Name: pam_smtpauth
Version: %{version}
Release: %{release}%{?dist}
Source0: %{name}-%{version}.tar.gz
License: GPL
Vendor: HDE, Inc.
Packager: Taizo ITO <taizo.ito@hde.co.jp>
URL: http://sourceforge.jp/projects/pam-smtpauth/
Group: System Environment/Base
BuildRoot: %{_tmppath}/%{name}-root

Requires: pam > 0.70
BuildRequires: pam-devel

%if %{with_smtps}
%if "%{vendor_openssl}" != ""
Requires: %{vendor_openssl}
BuildRequires: %{vendor_openssl}-devel
%else
Requires: openssl
BuildRequires: openssl-devel
%endif
BuildRequires: krb5-devel
%endif

### include local configuration
%{?include_specopt}

%description
This is pam_smtpauth, a pluggable authentication module that can be used with
Linux-PAM and SMTP Authentication.

%prep 
%setup -q

%build
%if "%{vendor_libdir}" != ""
LIBS="-I%{vendor_includedir} -L%{vendor_libdir}"
export LIBS
LDFLAGS="${LDFLAGS} -Wl,-rpath,%{vendor_libdir} -L%{vendor_libdir}"
export LDFLAGS
%endif
%configure \
  --prefix=%{_prefix} \
  --libdir=%{_libdir} \
  --enable-debug=yes \
  --includedir=%{vendor_includedir} \
%if %{with_smtps}
  --enable-ssl=yes \
  --with-krb5-dir=%{_prefix}/kerberos \
%endif

%if "%{vendor_libdir}" != ""
CFLAGS="-fPIC -I%{vendor_includedir} -Wl,-rpath,%{vendor_libdir} -L%{vendor_libdir}"
%else
CFLAGS="-fPIC"
%endif
export CFLAGS
make %{?_smp_mflags} CFLAGS="${CFLAGS}" || make CFLAGS="${CFLAGS}"

## make check

%install
%makeinstall

%{__install} -d -m0755 %{buildroot}%{_sysconfdir}/%{name}
%{__install} -m0644 sample/pam.smtp %{buildroot}%{_sysconfdir}/%{name}/pam.smtp

%clean
rm -rf $RPM_BUILD_ROOT

%post
## the first installation
#if [ $1 = 1 ]; then
#  /usr/sbin/alternatives --install /etc/pam.d/smtp mta-pam %{_sysconfdir}/%{name}/pam.smtp 90
#fi
true

%preun
## the last uninstallation
#if [ $1 = 0 ]; then
#  /usr/sbin/alternatives --remove mta-pam %{_sysconfdir}/%{name}/pam.smtp
#  echo "" | /usr/sbin/alternatives --config mta
#fi
true

%files
%defattr(-,root,root)
%doc NEWS INSTALL README ChangeLog AUTHORS CONFIGURATION.eucjp sample
%{_libdir}/security/*
%config(noreplace) %{_sysconfdir}/pam_smtpauth.conf
%config %{_sysconfdir}/%{name}/pam.smtp
%{_mandir}/man5/pam_smtpauth.5.gz

%changelog
* Mon Oct 3 2011 Taizo ITO <taizo.ito@hde.co.jp> 1.0.0-1
- Added new configuration parameter - TryMechs.

* Tue Apr 21 2010 Taizo ITO <taizo.ito@hde.co.jp> 0.9.9-1
- Within NAT environment, a smtp greeting message cannot be received correctly.

* Tue Apr 21 2010 Taizo ITO <taizo.ito@hde.co.jp> 0.9.8-2
- Fixed libssl link option bug.

* Tue Jan 19 2010 Taizo ITO <taizo.ito@hde.co.jp>
- Added 'TryMethod' parameter in configuration file.

* Fri Aug 7 2009 Taizo ITO <taizo.ito@hde.co.jp>
- New upstream release.

* Tue Jun 22 2009 Taizo ITO <taizo.ito@hde.co.jp>
- version 0.9.3 build.
- support digest-md5 mechanism.

* Tue Jun 16 2009 Taizo ITO <taizo.ito@hde.co.jp>
- version 0.9.2 build.
- support smtps connection.

* Thu Jun 11 2009 Taizo ITO <taizo.ito@hde.co.jp>
- Initial 0.9.1 build.
