/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.server;

import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.facade.ReceiveMessageFacade;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.Response;
import jp.valtech.bts.network.command.TCPServerCommand;


/**
 * <dl>
 *   <dt><b>クライアントからメッセージ送信要求処理を行います。</b></dt>
 *   <dd><ul>
 * 	   <li>他のクライアントからのメッセージ受信し、このクラスが呼び出されると、送信されたメッセージを受け取ります。受信できるメッセージはひとつのみです。
 * 	   <li>メッセージを受け取ると、レスポンスを作成します。レスポンスには受信が成功したかどうかを設定するだけです。
 *     <li>エラーが発生した場合には、えらー情報をレスポンスメッセージに格納します。
 *   </ul></dd>
 * </dl>
 * 
 * @see			jp.valtech.bts.command.client.SendMessage
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class SendMessageServer extends TCPServerCommand {

	/**
	 * なにもしない。
	 */
	public SendMessageServer() {
		super();
	}

	/**
	 * {@link jp.valtech.bts.network.Request リクエストオブジェクト}からメッセージを取得します。
	 * メッセージ受信を確認すると{@link jp.valtech.bts.network.Response レスポンスオブジェクト}に
	 * {@link Response#OK}を設定して送信元に返信します。<br>
	 * 受信したメッセージのローカルDBへの登録は返信後に行います。DBへの登録処理結果は送信元には通知しません。
	 * 
	 * @param		request			リクエストオブジェクト
	 * @param		response		レスポンスオブジェクト
	 * @param		myconfig		ローカル端末のネットワーク情報
	 */
	public void execute(Request request, Response response, NetworkConfig myconfig){
		
		// メッセージ取得
		MessagePacket messagePacket =(MessagePacket)request.getParameterObject( "message" );

		// 受信オブジェクトのチェック。チェック結果を送信元に返信します。
		// 後で行うDBへの登録処理の結果は送信元には送りません。
		if( messagePacket == null) {
			
			// "Response#ERROR"を送信元に返信
			response.setCode(Response.ERROR);
			response.setMessage("NullPointerException : MessagePacket is null");
			reply(response);
			return;
		}

		// "Response#OK"を送信元に返信
		response.setCode(Response.OK);
		reply(response);
	
		// 受け取ったメッセージをDBに登録
		ReceiveMessageFacade facade = new ReceiveMessageFacade();
		facade.addMessage(messagePacket);
	}
}
