/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.connection;


/**
 * 課題票の更新・参照処理専用のコネクションクラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class IssueDBConnection extends DBConnection {

	/** 処理種別の識別文字列 */
	public static String PROCESS_TYPE = "_issue";

	/**
	 * コネクションを生成します。
	 *
	 */
	public IssueDBConnection() {
		super(null, PROCESS_TYPE);
	}

	/**
	 * コネクションを生成します。
	 *
	 * @param		ssid		SSID
	 */
	public IssueDBConnection(String ssid) {
		super(ssid, PROCESS_TYPE);
	}

	/**
	 * コネクションを生成します。
	 * 
	 * @param		ssid			SSID
	 * @param		currentDir		DBファイルのPATH
	 * @deprecated	テスト専用
	 */
	public IssueDBConnection(String ssid, String currentDir) {
		super(ssid, PROCESS_TYPE, currentDir);
	}
	
}
