/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.beans.XMLEncoder;

/**
 * 
 * {@link XMLEncoder}を利用して担当者別課題票件数をXMLに出力するためのJavaBeansクラスです。
 * {@link XMLEncoder}を利用するにはデフォルトコンストラクタが存在しなければなりません。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class OutputAssigned {

	/** 担当者 */
	private String assigned;
	
	/** 「担当者割り当て(未対応)」カウント */
	private String assignedCnt;
	
	/** 「対応済み」カウント */
	private String resolvedCnt;
	
	/** 「確認済み」カウント */
	private String verifiedCnt;
	
	/** 「完了」カウント */
	private String closedCnt;
	
	/** 担当者別課題票カウント */
	private String sum;
	
	/** 「担当者割り当て(未対応)」率 */
	private String assignedRate;
	
	/** 「担当者割り当て(未対応)」合計 */
	private String assignedSum;
	
	/** 「対応済み」合計 */
	private String resolvedSum;
	
	/** 「確認済み」合計 */
	private String verifiedSum;
	
	/** 「完了」合計 */
	private String closedSum;
	
	/** 課題票合計 */
	private String allSum;
	
	/** 「担当者割り当て(未対応)」率の平均 */
	private String assignedRateAvg;
	
	/** 「起票(担当者未割り当て)」カウント */
	private String openedCnt;
	
	/** ヘッダ文字列 */
	private String header;
	
	/** フッタ文字列 */
	private String footer;
	
	/** レポート出力日時(yyyy/MM/dd HH:mm) */
	private String nowDate;
	
	
	/**
	 * デフォルトコンストラクタです。
	 */
	public OutputAssigned() {
	}


	/**
	 * @return allSum を戻します。
	 */
	public String getAllSum() {
		return allSum;
	}


	/**
	 * @param allSum 設定する allSum。
	 */
	public void setAllSum(String allSum) {
		this.allSum = allSum;
	}


	/**
	 * @return assigned を戻します。
	 */
	public String getAssigned() {
		return assigned;
	}


	/**
	 * @param assigned 設定する assigned。
	 */
	public void setAssigned(String assigned) {
		this.assigned = assigned;
	}


	/**
	 * @return assignedCnt を戻します。
	 */
	public String getAssignedCnt() {
		return assignedCnt;
	}


	/**
	 * @param assignedCnt 設定する assignedCnt。
	 */
	public void setAssignedCnt(String assignedCnt) {
		this.assignedCnt = assignedCnt;
	}


	/**
	 * @return assignedRate を戻します。
	 */
	public String getAssignedRate() {
		return assignedRate;
	}


	/**
	 * @param assignedRate 設定する assignedRate。
	 */
	public void setAssignedRate(String assignedRate) {
		this.assignedRate = assignedRate;
	}


	/**
	 * @return assignedRateAvg を戻します。
	 */
	public String getAssignedRateAvg() {
		return assignedRateAvg;
	}


	/**
	 * @param assignedRateAvg 設定する assignedRateAvg。
	 */
	public void setAssignedRateAvg(String assignedRateAvg) {
		this.assignedRateAvg = assignedRateAvg;
	}


	/**
	 * @return assignedSum を戻します。
	 */
	public String getAssignedSum() {
		return assignedSum;
	}


	/**
	 * @param assignedSum 設定する assignedSum。
	 */
	public void setAssignedSum(String assignedSum) {
		this.assignedSum = assignedSum;
	}


	/**
	 * @return closedCnt を戻します。
	 */
	public String getClosedCnt() {
		return closedCnt;
	}


	/**
	 * @param closedCnt 設定する closedCnt。
	 */
	public void setClosedCnt(String closedCnt) {
		this.closedCnt = closedCnt;
	}


	/**
	 * @return closedSum を戻します。
	 */
	public String getClosedSum() {
		return closedSum;
	}


	/**
	 * @param closedSum 設定する closedSum。
	 */
	public void setClosedSum(String closedSum) {
		this.closedSum = closedSum;
	}


	/**
	 * @return footer を戻します。
	 */
	public String getFooter() {
		return footer;
	}


	/**
	 * @param footer 設定する footer。
	 */
	public void setFooter(String footer) {
		this.footer = footer;
	}


	/**
	 * @return header を戻します。
	 */
	public String getHeader() {
		return header;
	}


	/**
	 * @param header 設定する header。
	 */
	public void setHeader(String header) {
		this.header = header;
	}


	/**
	 * @return nowDate を戻します。
	 */
	public String getNowDate() {
		return nowDate;
	}


	/**
	 * @param nowDate 設定する nowDate。
	 */
	public void setNowDate(String nowDate) {
		this.nowDate = nowDate;
	}


	/**
	 * @return openedCnt を戻します。
	 */
	public String getOpenedCnt() {
		return openedCnt;
	}


	/**
	 * @param openedCnt 設定する openedCnt。
	 */
	public void setOpenedCnt(String openedCnt) {
		this.openedCnt = openedCnt;
	}


	/**
	 * @return resolvedCnt を戻します。
	 */
	public String getResolvedCnt() {
		return resolvedCnt;
	}


	/**
	 * @param resolvedCnt 設定する resolvedCnt。
	 */
	public void setResolvedCnt(String resolvedCnt) {
		this.resolvedCnt = resolvedCnt;
	}


	/**
	 * @return resolvedSum を戻します。
	 */
	public String getResolvedSum() {
		return resolvedSum;
	}


	/**
	 * @param resolvedSum 設定する resolvedSum。
	 */
	public void setResolvedSum(String resolvedSum) {
		this.resolvedSum = resolvedSum;
	}


	/**
	 * @return sum を戻します。
	 */
	public String getSum() {
		return sum;
	}


	/**
	 * @param sum 設定する sum。
	 */
	public void setSum(String sum) {
		this.sum = sum;
	}


	/**
	 * @return verifiedCnt を戻します。
	 */
	public String getVerifiedCnt() {
		return verifiedCnt;
	}


	/**
	 * @param verifiedCnt 設定する verifiedCnt。
	 */
	public void setVerifiedCnt(String verifiedCnt) {
		this.verifiedCnt = verifiedCnt;
	}


	/**
	 * @return verifiedSum を戻します。
	 */
	public String getVerifiedSum() {
		return verifiedSum;
	}


	/**
	 * @param verifiedSum 設定する verifiedSum。
	 */
	public void setVerifiedSum(String verifiedSum) {
		this.verifiedSum = verifiedSum;
	}


}
