/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.facade;

import jp.valtech.bts.connection.IssueDBConnection;
import jp.valtech.bts.connection.MessageDBConnection;
import jp.valtech.bts.connection.VoteDBConnection;
import jp.valtech.bts.dao.AttachmentDAO;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.dao.CommentHistoryDAO;
import jp.valtech.bts.dao.IssueDAO;
import jp.valtech.bts.dao.IssueHistoryDAO;
import jp.valtech.bts.dao.MessagePacketDAO;
import jp.valtech.bts.dao.VoteDAO;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

/**
 * データベースを初期化します。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class DatabaseInitializer implements Logging {

	/**
	 * 何もしません。
	 */
	public DatabaseInitializer() {
	}

	/**
	 * データベースを初期化します。
	 * 
	 * @param		ssid		初期化するプロジェクトのSSID
	 */
	public static void Initialize(String ssid) {
		

		// 課題票情報更新DAO
		IssueDBConnection issueDBCon = new IssueDBConnection(ssid);
		IssueDAO 		  issue   = new IssueDAO( issueDBCon );
		IssueHistoryDAO   history = new IssueHistoryDAO( issueDBCon );
		AttachmentDAO 	  attach  = new AttachmentDAO( issueDBCon );
		CommentHistoryDAO comment = new CommentHistoryDAO( issueDBCon );

		// メッセージ情報更新DAO
		MessageDBConnection msgDBCon = new MessageDBConnection(ssid);
		MessagePacketDAO  message 	= new MessagePacketDAO( msgDBCon );

		// 投票情報更新DAO
		VoteDBConnection voteDBCon = new VoteDBConnection(ssid); 
		VoteDAO vote = new VoteDAO( voteDBCon );

		// テーブルを一旦削除
		{
			try {
				issue.dropTable();
			} catch ( BtsDBException e ) {
				;
			}
			try {
				history.dropTable();
			} catch ( BtsDBException e ) {
				;
			}
			try {
				message.dropTable();
			} catch ( BtsDBException e ) {
				;
			}
			try {
				vote.dropTable();
			} catch ( BtsDBException e ) {
				;
			}
			try {
				attach.dropTable();
			} catch ( BtsDBException e ) {
				;
			}
			try {
				comment.dropTable();
			} catch ( BtsDBException e ) {
				;
			}
		}

		// テーブルを生成
		try {
			issue.createTable();
			history.createTable();
			message.createTable();
			vote.createTable();
			attach.createTable();
			comment.createTable();
		} catch ( Exception e ) {
			String msg = Messages.getString("DatabaseInitializer.0"); //$NON-NLS-1$
			logger.fatal(msg, e);
			BtsPlugin.getInstance().error(msg, e);
		} finally{
			issueDBCon.close();
			issueDBCon =null;
			
			voteDBCon.close();
			voteDBCon = null;
			
			msgDBCon.close();
			msgDBCon = null;
		}
	}
}
