/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.network.command;

import java.net.DatagramPacket;
import java.net.InetAddress;

import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.util.Logging;

/**
 * UDP/マルチキャスト通信処理を受け付ける受信側コマンド処理の基底クラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public abstract class MulticastServerCommand implements Runnable, Logging {

	/** ローカル端末のネットワーク設定 */
	private NetworkConfig myconfig	= null;
	
	/** リクエストデータ */
	private Request request		= null;

	/** 受信したデータグラムパケット。*/
	private DatagramPacket packet	= null;

	/**
	 * コマンドインスタンス生成。 
	 */
	public MulticastServerCommand() {
		super();
	}

	
	/**
	 * Multicastレシーバインスタンスを格納します。
	 * 
	 * @param		receiver		Multicastレシーバインスタンス
	 */
	public void setPacket( DatagramPacket packet ) {
		this.packet = packet;
	}
	
	/**
	 * <DL><DT><B>リクエストデータを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param request リクエストデータ。
	 */
	public void setRequest( Request request ) {
		this.request = request;
	}

	/**
	 * <DL><DT><B>configを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param config config。
	 */
	public void setConfig( NetworkConfig myconfig ) {
		this.myconfig = myconfig;
	}

	
	/**
	 * リクエストの送信元ホストの情報を{@link InetAddress}の形式で返します。
	 * 
	 * @return		リクエスト送信元のホスト情報
	 */
	protected InetAddress getRequestClient() {
		return packet.getAddress();
	}

	/**
	 * <DL><DT><B>コマンド実行処理(スレッド処理)</B></DL>
	 *  <DD>コマンド実行をスレッドで行うためのメソッドです。
	 *  {@link Thread}クラスを利用して実行してください。
	 *  </DD>
	 * </DL>
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		execute(request, myconfig);
	}

	/**
	 * Multicastサーバコマンドを実行します。
	 * 
	 * @param		request			リクエストオブジェクト
	 * @param		myconfig		ローカル端末のネットワーク情報
	 */
	public abstract void execute(Request request, NetworkConfig myconfig);
}
