/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.navigator;

import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.swt.graphics.Image;

/**
 * カテゴリ用のツリーノードです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class CategoryNode extends BtsTreeNode implements IChildCountNode {

	/** このノードのイメージファイル */
	private static final Image IMAGE = BtsPlugin.getInstance().getImage("category.gif"); 
	
	/** このノードが持つ子ノードの数 */
	private int childCount = 0;
	
	
	/**
     * 親ノード・名前を設定します。
     * 
     * @param		parent				このノードの親
     * @param		textName			このノードの表示名
	 */
	public CategoryNode(BtsTreeNode parent, String textName) {
		super(parent, textName, IMAGE);
	}
	
	/*
	 *  (非 Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CategoryNode) {
			CategoryNode that = (CategoryNode)obj;
			return textName.equals(that.getTextName());
		}
		return false;
		
	}

	/*
	 *  (非 Javadoc)
	 * @see jp.valtech.bts.ui.navigator.IChildCountNode#getChildCount()
	 */
	public int getChildCount() {
		return childCount;
	}
	
	/**
	 * 子ノードの数をインクリメントします。
	 *
	 */
	public void incrementChildCount() {
		childCount++;
	}
	
	/**
	 * 子ノードの数をデクリメントします。
	 * 当該カテゴリに属する課題票が無くなった場合は自分を削除します。
	 *
	 */
	public void decrementChildCount() {
		childCount--;

		// カテゴリに属する課題票の数が０件になったらそのカテゴリノードを削除する
		if(childCount == 0) {
			parent.removeChild(this);
		}
	}

}
