/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.preference;

import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * 共通設定画面（Papilio）を生成します。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class PreferencePage extends FieldEditorPreferencePage implements
		IWorkbenchPreferencePage {
	
	/**
	 * 初期設定
	 */
	public PreferencePage() {
		super(GRID);
		setPreferenceStore(BtsPlugin.getInstance().getPreferenceStore());
		setDescription(Messages.getString("PreferencePage.0")); //$NON-NLS-1$
		// 「デフォルトの復元」「適用」ボタンの削除
		super.noDefaultAndApplyButton();
	}
	

	/*
	 *  (非 Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
	 */
	public void createFieldEditors() {
	}

	/*
	 *  (非 Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
}

/*
 * ここで設定した値は以下の場所に保存されます。
 *   （プラグイン開発ワークスペース）/.metadata/.plugins/org.eclipse.core.runtime/.settings/ の下、プラグインIDと同じ名前のファイル
  * 
 */
