/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.connection.MessageDBConnection;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.dao.DataBaseAccessor;
import jp.valtech.bts.data.MessagePacket;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class MessagePacketDAO
extends DataBaseAccessor {
    private static final String CREATE_TABLE = "CREATE TABLE MESSAGEPACKET  ( MESSAGEID      INTEGER NOT NULL IDENTITY PRIMARY KEY  , MESSAGETYPE    CHAR(1)  , FROMUSER       VARCHAR(30)  , SENT           TIMESTAMP  , MESSAGE        LONGVARCHAR  , ATTACHFILENAME VARCHAR(60)  , FINGERPRINT    VARCHAR(40)  , ISSUETYPE      CHAR(1)  , OPENED         BOOLEAN DEFAULT FALSE  )";
    private static final String DROP_TABLE = "DROP TABLE MESSAGEPACKET CASCADE;";
    private static final String INSERT_SQL = "INSERT INTO MESSAGEPACKET  ( MESSAGETYPE  , FROMUSER  , SENT  , MESSAGE  , ATTACHFILENAME  , FINGERPRINT  , ISSUETYPE , OPENED  ) VALUES (?, ?, ?, ?, ?, ?, ?, FALSE)";
    private static final String SET_OPENED = "UPDATE MESSAGEPACKET SET OPENED=TRUE WHERE MESSAGEID=?";
    private static final String SELECT_ALL = "SELECT   MESSAGEID , MESSAGETYPE , FROMUSER , SENT , MESSAGE , ATTACHFILENAME , FINGERPRINT , ISSUETYPE , nvl(OPENED, false) OPENED FROM MESSAGEPACKET";
    private static final String GET_FROMUSER = "SELECT DISTINCT FROMUSER FROM MESSAGEPACKET";
    private static final String DELETE_SQL = "DELETE FROM MESSAGEPACKET WHERE MESSAGEID=?";
    private static final String SELECT_MAX_ID = "SELECT MAX(MESSAGEID) FROM MESSAGEPACKET;";
    static /* synthetic */ Class class$0;

    public MessagePacketDAO(MessageDBConnection connection) {
        super(connection);
    }

    public void createTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, CREATE_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void dropTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, DROP_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void addMessage(MessagePacket messagePacket) throws BtsDBException {
        try {
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(messagePacket.getMessageType());
            param.add(messagePacket.getFromUser());
            if (messagePacket.getSent() != null) {
                param.add(new Timestamp(messagePacket.getSent().getTime()));
            } else {
                param.add(null);
            }
            param.add(messagePacket.getMessage());
            param.add(messagePacket.getAttachFileName());
            param.add(messagePacket.getFingerPrint());
            param.add(messagePacket.getIssueType());
            new QueryRunner().update(this.con, INSERT_SQL, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void deleteByMessageID(int messageID) throws BtsDBException {
        try {
            new QueryRunner().update(this.con, DELETE_SQL, (Object)new Integer(messageID));
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void setOpend(int messageID) throws BtsDBException {
        try {
            new QueryRunner().update(this.con, SET_OPENED, (Object)new Integer(messageID));
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public MessagePacket[] getAllMessage() throws BtsDBException {
        MessagePacket[] messages = new MessagePacket[]{};
        try {
            List result = this.getMessageList();
            messages = result.toArray(messages);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
        return messages;
    }

    public List getMessageList() throws BtsDBException {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.MessagePacket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanListHandler rsh = new BeanListHandler((Class)clazz);
            List result = (List)new QueryRunner().query(this.con, SELECT_ALL, (ResultSetHandler)rsh);
            return result;
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public int getMaxMessageID() throws BtsDBException {
        try {
            ScalarHandler rsh = new ScalarHandler(1);
            Object result = new QueryRunner().query(this.con, SELECT_MAX_ID, (ResultSetHandler)rsh);
            if (result == null) {
                return 0;
            }
            return Integer.parseInt(result.toString());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public String[] getFromUser() throws BtsDBException {
        try {
            ArrayListHandler rsh = new ArrayListHandler();
            List list = (List)new QueryRunner().query(this.con, GET_FROMUSER, (ResultSetHandler)rsh);
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < list.size()) {
                if (((Object[])list.get(i))[0] != null && !"".equals(((Object[])list.get(i))[0])) {
                    result.add(((Object[])list.get(i))[0]);
                }
                ++i;
            }
            return result.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }
}

