/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.dao;

import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.connection.DBConnection;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.dao.DataBaseAccessor;
import jp.valtech.bts.data.Vote;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class VoteDAO
extends DataBaseAccessor {
    private static final String CREATE_TABLE = "CREATE TABLE VOTE ( FINGERPRINT CHAR(40) , VOTEUSER \t  VARCHAR(30) , VOTECNT \t  INTEGER DEFAULT 0 ) ;";
    private static final String DROP_TABLE = "DROP TABLE VOTE CASCADE;";
    private static final String INSERT_SQL = "INSERT INTO VOTE ( FINGERPRINT , VOTEUSER , VOTECNT ) VALUES (?, ?, ?)";
    private static final String DELETE_SQL = "DELETE FROM VOTE WHERE FINGERPRINT=?";
    private static final String SELECT_ALL = "SELECT   FINGERPRINT , VOTEUSER , VOTECNT FROM VOTE";
    private static final String SELECT_BY_FINGERPRINT = "SELECT   FINGERPRINT , VOTEUSER , VOTECNT FROM VOTE WHERE FINGERPRINT=?";
    private static final String UPDATE_VOTECNT = "UPDATE VOTE   SET VOTECNT=VOTECNT+1 WHERE FINGERPRINT=? AND VOTEUSER=?";
    private static final String VOTECNT_SUM = "SELECT SUM ( VOTECNT ) FROM VOTE WHERE FINGERPRINT=?";
    static /* synthetic */ Class class$0;

    public VoteDAO(DBConnection connection) {
        super(connection);
    }

    public void createTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, CREATE_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void dropTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, DROP_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void insert(Vote vote) throws BtsDBException {
        try {
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(vote.getFingerPrint());
            param.add(vote.getVoteUser());
            param.add(new Integer(vote.getVoteCnt()));
            new QueryRunner().update(this.con, INSERT_SQL, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void deleteByFingerPrint(String fingerPrint) throws BtsDBException {
        try {
            new QueryRunner().update(this.con, DELETE_SQL, (Object)fingerPrint);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public Vote[] get(String fingerPrint) throws BtsDBException {
        Vote[] votes = new Vote[]{};
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.Vote");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanListHandler rsh = new BeanListHandler((Class)clazz);
            List result = (List)new QueryRunner().query(this.con, SELECT_BY_FINGERPRINT, (Object)fingerPrint, (ResultSetHandler)rsh);
            votes = result.toArray(votes);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
        return votes;
    }

    public int cntPlus(Vote vote) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(vote.getFingerPrint());
            param.add(vote.getVoteUser());
            return new QueryRunner().update(this.con, UPDATE_VOTECNT, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public int getSum(String fingerPrint) throws BtsDBException {
        try {
            ScalarHandler rsh = new ScalarHandler(1);
            Object result = new QueryRunner().query(this.con, VOTECNT_SUM, (Object)fingerPrint, (ResultSetHandler)rsh);
            if (result == null) {
                return 0;
            }
            return Integer.parseInt(result.toString());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }
}

