/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.data;

import java.util.ArrayList;
import java.util.Iterator;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.IProjectDialogSettings;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;

public class CurrentProject
implements Logging {
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static CurrentProject instance;
    private ProjectConfig currentConfig = new ProjectConfig();
    private boolean open = false;
    private ArrayList actions = new ArrayList();

    private CurrentProject() {
    }

    public static synchronized CurrentProject getInsance() {
        if (instance == null) {
            instance = new CurrentProject();
        }
        return instance;
    }

    public void setCurrentProject(String ssid) {
        IProjectDialogSettings setting = BtsPlugin.getInstance().getProjectDialogSettings().getSection(ssid);
        this.currentConfig.setProjectName(setting.get("PROJECT"));
        this.currentConfig.setUserName(setting.get("USER"));
        this.currentConfig.setSsid(setting.get("SSID"));
        this.currentConfig.setMailCheck(setting.getBoolean("MAILCHECK"));
        this.currentConfig.setSmtp(setting.get("SMTP"));
        this.currentConfig.setSender(setting.get("SENDER"));
        this.currentConfig.setRecipient(setting.get("RECIPIENT"));
        this.currentConfig.setPrefix(setting.get("PREFIX"));
        this.currentConfig.setCategory(setting.get("CATEGORY"));
        this.currentConfig.setPriority(setting.get("PRIORITY"));
        this.currentConfig.setAssigned(setting.get("ASSIGNED"));
        this.currentConfig.setVoteCheck(setting.getBoolean("VOTECHECK"));
        this.currentConfig.setVote(setting.get("VOTE"));
        this.currentConfig.setUntilDeadLineCheck(setting.getBoolean("UNTILDEADLINECHECK"));
        this.currentConfig.setUntilDeadLine(setting.get("UNTILDEADLINE"));
        this.currentConfig.setFixedSyncCheck(setting.getBoolean("FIXEDSYNCCHECK"));
        this.currentConfig.setAddress1(setting.get("ADDRESS1"));
        this.currentConfig.setAddress2(setting.get("ADDRESS2"));
        this.currentConfig.setAddress3(setting.get("ADDRESS3"));
        this.currentConfig.setAddress4(setting.get("ADDRESS4"));
        this.currentConfig.setPort(setting.get("PORT"));
        this.currentConfig.setAutoSyncCheck(setting.getBoolean("AUTOSYNCCHECK"));
        this.currentConfig.setNormalSyncRadio(setting.getBoolean("NORMALSYNCRADIO"));
        this.currentConfig.setAppointSyncRadio(setting.getBoolean("APPOINTSYNCRADIO"));
        this.open = true;
        this.setActionsEnabled(true);
    }

    public void setProjectConfig(ProjectConfig projectconfig) {
        String thisSSID = this.currentConfig.getSsid();
        String thatSSID = projectconfig.getSsid();
        if (thatSSID.equals(thisSSID)) {
            this.currentConfig = projectconfig;
        }
    }

    public ProjectConfig getProjectConfig() {
        if (!this.isOpen()) {
            return null;
        }
        return this.currentConfig;
    }

    public String getSSID() {
        if (!this.isOpen()) {
            return null;
        }
        return this.currentConfig.getSsid();
    }

    public boolean isCurrentProject(String ssid) {
        if (!this.isOpen()) {
            return false;
        }
        return ssid.equals(this.currentConfig.getSsid());
    }

    public boolean isCurrentProject(ProjectConfig projectconfig) {
        if (!this.isOpen()) {
            return false;
        }
        return projectconfig.getSsid().equals(this.currentConfig.getSsid());
    }

    public void close() {
        this.open = false;
        this.setActionsEnabled(false);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void setActionsEnabled(boolean enabled) {
        Iterator it = this.actions.iterator();
        while (it.hasNext()) {
            Action action = (Action)it.next();
            action.setEnabled(enabled);
        }
    }

    public void removeAction(Action action) {
        this.actions.remove(action);
    }

    public String getBaseDir() {
        String baseDir = BtsPlugin.getInstance().getStateLocation().toString();
        String ssid = this.currentConfig.getSsid();
        String ssidDir = String.valueOf(baseDir) + SEPARATOR + ssid + SEPARATOR;
        return ssidDir;
    }
}

