/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.data.CommentHistory;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.data.Messages;
import jp.valtech.bts.data.Vote;

public class Issue
implements Serializable {
    private static final String ISSUID_SEPARATOR = "#";
    private static final long serialVersionUID = -3116949077223546596L;
    public static final int DEADLINE_SAFE = 0;
    public static final int DEADLINE_WARNING = 1;
    public static final int DEADLINE_OVER = 2;
    private int issueID = 0;
    private String fingerPrint = null;
    private String type = null;
    private String category = null;
    private String title = null;
    private String description = null;
    private String priority = null;
    private Date deadline = null;
    private String status = null;
    private String assigned = null;
    private Boolean secretBug = null;
    private Boolean suspend = null;
    private String createUser = null;
    private Date createDate = null;
    private Date updateDate = null;
    private Integer version = new Integer(0);
    private ArrayList attachmentList = new ArrayList();
    private IssueHistory[] issueHistory = null;
    private CommentHistory[] commentHistory = null;
    private Vote[] votes = null;
    private int updateCnt = 0;

    public int getIssueID() {
        return this.issueID;
    }

    public String getDisplayIssueID() {
        if (this.issueID == 0) {
            return "";
        }
        return String.valueOf(this.category) + ISSUID_SEPARATOR + this.issueID;
    }

    public void setIssueID(int issueID) {
        this.issueID = issueID;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        if (this.fingerPrint != null) {
            throw new RuntimeException(Messages.getString("Issue.0"));
        }
        this.fingerPrint = fingerPrint;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setDeadline(Date deadline) {
        if (deadline != null) {
            this.deadline = new Date(deadline.getTime());
        }
    }

    public void setDeadline(long timestamp) {
        this.deadline = new Date(timestamp);
    }

    public Date getDeadline() {
        return this.deadline;
    }

    public long getDeadlineTimestamp() {
        return this.deadline.getTime();
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAssigned() {
        return this.assigned;
    }

    public void setAssigned(String assigned) {
        this.assigned = assigned;
    }

    public Boolean isSecretBug() {
        return this.secretBug;
    }

    public Boolean getSecretBug() {
        return this.secretBug;
    }

    public void setSecretBug(Boolean secretBug) {
        this.secretBug = secretBug;
    }

    public void setSecretBug(boolean secretBug) {
        this.secretBug = new Boolean(secretBug);
    }

    public Boolean isSuspend() {
        return this.suspend;
    }

    public Boolean getSuspend() {
        return this.suspend;
    }

    public void setSuspend(Boolean suspend) {
        this.suspend = suspend;
    }

    public void setSuspend(boolean suspend) {
        this.suspend = new Boolean(suspend);
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public void setCreateDate(Date createDate) {
        if (createDate != null) {
            this.createDate = new Date(createDate.getTime());
        }
    }

    public void setCreateDate(long timestamp) {
        this.createDate = new Date(timestamp);
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public long getCreateDateTimestamp() {
        return this.createDate.getTime();
    }

    public void setUpdateDate(Date updateDate) {
        if (updateDate != null) {
            this.updateDate = new Date(updateDate.getTime());
        }
    }

    public void setUpdateDate(long timestamp) {
        this.updateDate = new Date(timestamp);
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public long getUpdateDateTimestamp() {
        return this.updateDate.getTime();
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setVersion(int version) {
        this.version = new Integer(version);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKey() {
        return String.valueOf(this.fingerPrint) + this.type;
    }

    public ArrayList getAttachmentList() {
        return this.attachmentList;
    }

    public Attachment[] getAttachments() {
        if (this.attachmentList == null || this.attachmentList.size() == 0) {
            return null;
        }
        return this.attachmentList.toArray(new Attachment[0]);
    }

    public void setAttachmentList(ArrayList attachmentList) {
        this.attachmentList = attachmentList;
    }

    public CommentHistory[] getCommentHistories() {
        return this.commentHistory;
    }

    public void setCommentHistories(CommentHistory[] commentHistory) {
        this.commentHistory = commentHistory;
    }

    public IssueHistory[] getIssueHistories() {
        return this.issueHistory;
    }

    public void setIssueHistories(IssueHistory[] issueHistory) {
        this.issueHistory = issueHistory;
    }

    public int getUpdateCnt() {
        return this.updateCnt;
    }

    public void setUpdateCnt(int updateCnt) {
        this.updateCnt = updateCnt;
    }

    public Vote[] getVotes() {
        return this.votes;
    }

    public void setVotes(Vote[] votes) {
        this.votes = votes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.fingerPrint == null || "".equals(this.fingerPrint)) {
            return false;
        }
        if (obj instanceof Issue) {
            Issue that = (Issue)obj;
            return this.getKey().equals(that.getKey());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{issueID=").append(this.issueID);
        buf.append(", fingerPrint=").append(this.fingerPrint);
        buf.append(", category=").append(this.category);
        buf.append(", title=").append(this.title);
        buf.append(", description=").append(this.description);
        buf.append(", priority=").append(this.priority);
        buf.append(", deadline=").append(this.deadline);
        buf.append(", status=").append(this.status);
        buf.append(", assigned=").append(this.assigned);
        buf.append(", secretBug=").append(this.secretBug);
        buf.append(", suspend=").append(this.suspend);
        buf.append(", createUser=").append(this.createUser);
        buf.append(", createDate=").append(this.createDate);
        buf.append(", updateDate=").append(this.updateDate);
        buf.append(", version=").append(this.version);
        buf.append("}");
        return buf.toString();
    }
}

