/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.data;

import java.io.Serializable;
import java.util.Date;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.Messages;

public class IssueHistory
implements Serializable {
    private static final long serialVersionUID = 7274918799052547464L;
    public static final String ISSUE_INITIAL_REGIST = Messages.getString("IssueHistory.0");
    public static final String ISSUE_NON_UPDATE = Messages.getString("IssueHistory.1");
    public static final String ISSUE_MOVE_GARBAGE = Messages.getString("IssueHistory.2");
    private String fingerPrint = "";
    private String type = "";
    private String updateAttribute = "";
    private String updateBefore = "";
    private String updateAfter = "";
    protected String updateUser = "";
    protected Date updateDate = null;

    public IssueHistory() {
    }

    public IssueHistory(Issue issue, String updateAttribute, String updateBefore, String updateAfter) {
        this.fingerPrint = issue.getFingerPrint();
        this.type = issue.getType();
        this.updateAttribute = updateAttribute;
        this.updateBefore = updateBefore;
        this.updateAfter = updateAfter;
        this.updateUser = CurrentProject.getInsance().getProjectConfig().getUserName();
        this.updateDate = issue.getUpdateDate();
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUpdateAfter() {
        return this.updateAfter;
    }

    public void setUpdateAfter(String updateAfter) {
        this.updateAfter = updateAfter;
    }

    public String getUpdateAttribute() {
        return this.updateAttribute;
    }

    public void setUpdateAttribute(String updateAtrribute) {
        this.updateAttribute = updateAtrribute;
    }

    public String getUpdateBefore() {
        return this.updateBefore;
    }

    public void setUpdateBefore(String updateBefore) {
        this.updateBefore = updateBefore;
    }

    public void setUpdateDate(Date updateDate) {
        if (updateDate != null) {
            this.updateDate = new Date(updateDate.getTime());
        }
    }

    public void setUpdateDate(long timestamp) {
        this.updateDate = new Date(timestamp);
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public long getUpdateDateTimestamp() {
        return this.updateDate.getTime();
    }
}

