/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.data;

import jp.valtech.bts.data.Messages;

public final class IssueType {
    private String description;
    private String value;
    public static final String RELEASE_VALUE = "R";
    public static final String CONFLICT_VALUE = "C";
    public static final String DRAFT_VALUE = "D";
    public static final String GARBAGE_VALUE = "G";
    public static final IssueType RELEASE = new IssueType("R", Messages.getString("IssueType.0"));
    public static final IssueType CONFLICT = new IssueType("C", Messages.getString("IssueType.1"));
    public static final IssueType DRAFT = new IssueType("D", Messages.getString("IssueType.2"));
    public static final IssueType GARBAGE = new IssueType("G", Messages.getString("IssueType.3"));

    private IssueType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static IssueType[] getEnums() {
        return new IssueType[]{RELEASE, CONFLICT, DRAFT, GARBAGE};
    }

    public static IssueType getEnumByValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Invalid IssueType-value : null");
        }
        IssueType[] issueType = IssueType.getEnums();
        int idx = 0;
        while (idx < issueType.length) {
            if (value.equals(issueType[idx].getValue())) {
                return issueType[idx];
            }
            ++idx;
        }
        throw new IllegalArgumentException("Invalid IssueType-value : " + value);
    }

    public static IssueType getEnumByDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("Invalid IssueType-value : null");
        }
        IssueType[] issueType = IssueType.getEnums();
        int idx = 0;
        while (idx < issueType.length) {
            if (description.equals(issueType[idx].getDescription())) {
                return issueType[idx];
            }
            ++idx;
        }
        throw new IllegalArgumentException("Invalid IssueType-value : " + description);
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }
}

