/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.facade;

import java.util.ArrayList;
import jp.valtech.bts.connection.IssueDBConnection;
import jp.valtech.bts.connection.VoteDBConnection;
import jp.valtech.bts.dao.AttachmentDAO;
import jp.valtech.bts.dao.CommentHistoryDAO;
import jp.valtech.bts.dao.IssueDAO;
import jp.valtech.bts.dao.IssueHistoryDAO;
import jp.valtech.bts.dao.VoteDAO;
import jp.valtech.bts.data.CommentHistory;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.data.Vote;
import jp.valtech.bts.facade.AttachmentFacade;
import jp.valtech.bts.facade.MessagePacketFacade;
import jp.valtech.bts.facade.Messages;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.core.runtime.IProgressMonitor;

public class SyncClientFacade
implements Logging {
    private ArrayList updateList = new ArrayList();
    private ArrayList addList = new ArrayList();
    private ArrayList garbageList = new ArrayList();

    /*
     * Exception decompiling
     */
    public void applySyncIssues(Issue[] syncIssues, Issue[] syncGarbages, IProgressMonitor monitor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 144->148)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void applyIssue(Issue[] syncIssues, IProgressMonitor monitor, IssueDBConnection issueDbcon, VoteDBConnection voteDbcon) throws Exception {
        monitor.subTask(Messages.getString("SyncClientFacade.3"));
        IssueDAO issueDAO = new IssueDAO(issueDbcon);
        IssueHistoryDAO historyDAO = new IssueHistoryDAO(issueDbcon);
        CommentHistoryDAO commentDAO = new CommentHistoryDAO(issueDbcon);
        VoteDAO voteDAO = new VoteDAO(voteDbcon);
        int i = 0;
        while (i < syncIssues.length) {
            int idx;
            Vote[] votes;
            CommentHistory[] comments;
            IssueHistory[] histories;
            Issue localIssue = issueDAO.getByFingerPrint(syncIssues[i].getFingerPrint(), "R");
            if (localIssue == null) {
                this.addList.add("[" + syncIssues[i].getDisplayIssueID() + "] " + syncIssues[i].getTitle());
                issueDAO.addIssue(syncIssues[i]);
                histories = syncIssues[i].getIssueHistories();
                int idx2 = 0;
                while (idx2 < histories.length) {
                    historyDAO.addHistory(histories[idx2]);
                    ++idx2;
                }
                comments = syncIssues[i].getCommentHistories();
                if (comments != null) {
                    int idx3 = 0;
                    while (idx3 < comments.length) {
                        commentDAO.addComment(comments[idx3]);
                        ++idx3;
                    }
                }
                AttachmentFacade.addFromEntity(syncIssues[i], issueDbcon);
                votes = syncIssues[i].getVotes();
                if (votes != null) {
                    idx = 0;
                    while (idx < votes.length) {
                        voteDAO.insert(votes[idx]);
                        ++idx;
                    }
                }
            } else {
                this.updateList.add("[" + syncIssues[i].getDisplayIssueID() + "] " + syncIssues[i].getTitle());
                issueDAO.modifyIssue(syncIssues[i], "R");
                historyDAO.deleteByFingerPrint(syncIssues[i].getFingerPrint(), "R");
                histories = syncIssues[i].getIssueHistories();
                int idx4 = 0;
                while (idx4 < histories.length) {
                    historyDAO.addHistory(histories[idx4]);
                    ++idx4;
                }
                commentDAO.deleteByFingerPrint(syncIssues[i].getFingerPrint(), "R");
                comments = syncIssues[i].getCommentHistories();
                if (comments != null) {
                    int idx5 = 0;
                    while (idx5 < comments.length) {
                        commentDAO.addComment(comments[idx5]);
                        ++idx5;
                    }
                }
                AttachmentFacade.deleteAll(syncIssues[i], "R", issueDbcon);
                AttachmentFacade.addFromEntity(syncIssues[i], issueDbcon);
                voteDAO.deleteByFingerPrint(syncIssues[i].getFingerPrint());
                votes = syncIssues[i].getVotes();
                if (votes != null) {
                    idx = 0;
                    while (idx < votes.length) {
                        voteDAO.insert(votes[idx]);
                        ++idx;
                    }
                }
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.getString("SyncClientFacade.4"));
            }
            monitor.worked(1);
            ++i;
        }
    }

    private void applyGarbage(Issue[] syncGarbages, IProgressMonitor monitor, IssueDBConnection issueDbcon) throws Exception {
        monitor.subTask(Messages.getString("SyncClientFacade.5"));
        IssueDAO issueDAO = new IssueDAO(issueDbcon);
        IssueHistoryDAO historyDAO = new IssueHistoryDAO(issueDbcon);
        CommentHistoryDAO commentDAO = new CommentHistoryDAO(issueDbcon);
        AttachmentDAO attachmentDAO = new AttachmentDAO(issueDbcon);
        int i = 0;
        while (i < syncGarbages.length) {
            String fingerPrint = syncGarbages[i].getFingerPrint();
            Issue releaseIssue = issueDAO.getByFingerPrint(fingerPrint, "R");
            if (releaseIssue != null) {
                this.garbageList.add("[" + syncGarbages[i].getDisplayIssueID() + "] " + syncGarbages[i].getTitle());
                issueDAO.changeGarbageVersion(fingerPrint);
                attachmentDAO.changeGarbageVersion(fingerPrint);
                historyDAO.changeGarbageVersion(fingerPrint);
                commentDAO.changeGarbageVersion(fingerPrint);
                IssueHistory[] histories = syncGarbages[i].getIssueHistories();
                if (histories != null && histories.length != 0) {
                    historyDAO.addHistory(histories[0]);
                }
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.getString("SyncClientFacade.4"));
            }
            monitor.worked(1);
            ++i;
        }
    }

    public void saveMessage(String syncUserName, String syncAddress) {
        MessagePacket message = new MessagePacket();
        message.setFromUser(syncUserName);
        message.setSent(System.currentTimeMillis());
        message.setMessageType("S");
        message.setMessage(this.createMessage(syncUserName, syncAddress));
        MessagePacketFacade facade = new MessagePacketFacade();
        facade.addMessage(message, false);
    }

    private String createMessage(String syncUserName, String syncAddress) {
        StringBuffer msg = new StringBuffer();
        msg.append(Messages.getString("SyncClientFacade.6")).append(BTSUtility.formatDate(System.currentTimeMillis()));
        msg.append("\n\n");
        msg.append(Messages.getString("SyncClientFacade.7"));
        msg.append("  (").append(syncAddress).append(")   ").append(syncUserName);
        msg.append("\n\n");
        msg.append(Messages.getString("SyncClientFacade.8"));
        String indent = "  ";
        String returnCode = "\n";
        msg.append(Messages.getString("SyncClientFacade.9")).append(this.addList.size()).append(Messages.getString("SyncClientFacade.10"));
        int i = 0;
        while (i < this.addList.size()) {
            msg.append(indent).append((String)this.addList.get(i)).append(returnCode);
            ++i;
        }
        msg.append(returnCode);
        msg.append(Messages.getString("SyncClientFacade.11")).append(this.updateList.size()).append(Messages.getString("SyncClientFacade.10"));
        i = 0;
        while (i < this.updateList.size()) {
            msg.append(indent).append((String)this.updateList.get(i)).append(returnCode);
            ++i;
        }
        msg.append(returnCode);
        msg.append(Messages.getString("SyncClientFacade.12")).append(this.garbageList.size()).append(Messages.getString("SyncClientFacade.10"));
        i = 0;
        while (i < this.garbageList.size()) {
            msg.append(indent).append((String)this.garbageList.get(i)).append(returnCode);
            ++i;
        }
        msg.append(returnCode);
        return msg.toString();
    }
}

