/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.network.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.MulticastServerCommand;
import jp.valtech.bts.network.server.Messages;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.IOUtility;
import jp.valtech.bts.util.Logging;

class MulticastServer
implements Runnable,
Logging {
    private NetworkConfig myconfig = null;
    private MulticastSocket multicastSocket = null;
    private InetAddress multicastAddrss = null;

    public MulticastServer(NetworkConfig myconfig) throws IOException {
        this.myconfig = myconfig;
        String address = myconfig.getMulticastAddress();
        int port = myconfig.getMulticastPort();
        this.multicastSocket = new MulticastSocket(port);
        this.multicastAddrss = InetAddress.getByName(address);
        this.multicastSocket.joinGroup(this.multicastAddrss);
        logger.info((Object)(String.valueOf(Messages.getString("MulticastServer.0")) + port + ",MulticastAddress:" + address + "}"));
    }

    public void run() {
        boolean active = true;
        while (active) {
            try {
                byte[] buf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.multicastSocket.receive(packet);
                byte[] receiveData = packet.getData();
                Request request = (Request)IOUtility.toObject(receiveData);
                if (this.isLocalRequest(packet)) continue;
                if (!this.isMyProject(request)) {
                    logger.info((Object)(String.valueOf(Messages.getString("MulticastServer.1")) + request.getSSID()));
                    continue;
                }
                Object command = BTSUtility.getCommand(request.getCommand());
                if (command != null && command instanceof MulticastServerCommand) {
                    MulticastServerCommand udpCommand = (MulticastServerCommand)command;
                    udpCommand.setRequest(request);
                    udpCommand.setPacket(packet);
                    udpCommand.setConfig(this.myconfig);
                    Thread t = new Thread((Runnable)udpCommand, "MulticastServerCommand");
                    t.start();
                    continue;
                }
                throw new ClassNotFoundException(Messages.getString("MulticastServer.2"));
            }
            catch (SocketException socketException) {
                logger.info((Object)Messages.getString("MulticastServer.3"));
                active = false;
            }
            catch (Exception e) {
                logger.error((Object)Messages.getString("MulticastServer.4"), (Throwable)e);
            }
        }
        logger.info((Object)Messages.getString("MulticastServer.5"));
    }

    public void stop() throws IOException {
        if (this.multicastSocket != null) {
            this.multicastSocket.leaveGroup(this.multicastAddrss);
            this.multicastSocket.close();
            this.multicastSocket = null;
        }
    }

    private boolean isMyProject(Request request) {
        String requestSSID = request.getSSID();
        if (requestSSID == null || requestSSID.equals("")) {
            throw new IllegalArgumentException(Messages.getString("MulticastServer.6"));
        }
        String mySSID = CurrentProject.getInsance().getSSID();
        return mySSID.equals(requestSSID);
    }

    private boolean isLocalRequest(DatagramPacket packet) {
        try {
            String localAddress = InetAddress.getLocalHost().getHostAddress();
            String remoteAddress = packet.getAddress().getHostAddress();
            return localAddress.equals(remoteAddress);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

