/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.network.server;

import java.io.IOException;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.server.Messages;
import jp.valtech.bts.network.server.MulticastServer;
import jp.valtech.bts.network.server.TCPServer;
import jp.valtech.bts.ui.BtsException;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

public class Server
implements Logging {
    private static Server server;
    private MulticastServer multicastServer = null;
    private TCPServer tcpServer = null;

    private Server() {
    }

    public static synchronized Server getServer() {
        if (server == null) {
            server = new Server();
        }
        return server;
    }

    public void startServer() throws BtsException {
        if (this.multicastServer != null) {
            try {
                this.multicastServer.stop();
            }
            catch (Exception exception) {}
        }
        if (this.tcpServer != null) {
            try {
                this.tcpServer.stop();
            }
            catch (Exception exception) {}
        }
        NetworkConfig config = new NetworkConfig();
        try {
            this.multicastServer = new MulticastServer(config);
        }
        catch (IOException e) {
            String msg = String.valueOf(Messages.getString("Server.0")) + Messages.getString("Server.1") + config.getMulticastPort() + Messages.getString("Server.2");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
            this.stopServer();
            throw new BtsException(msg, e);
        }
        try {
            this.tcpServer = new TCPServer(config);
        }
        catch (IOException e) {
            String msg = String.valueOf(Messages.getString("Server.3")) + Messages.getString("Server.4") + config.getTCPPort() + Messages.getString("Server.5");
            this.stopServer();
            throw new BtsException(msg, e);
        }
        Thread multicastThread = new Thread((Runnable)this.multicastServer, "MulticastServer");
        multicastThread.start();
        Thread tcpThread = new Thread((Runnable)this.tcpServer, "TCPServer");
        tcpThread.start();
        logger.info((Object)Messages.getString("Server.6"));
    }

    public void stopServer() {
        try {
            if (this.multicastServer != null) {
                this.multicastServer.stop();
                this.multicastServer = null;
            }
        }
        catch (Exception e) {
            logger.fatal((Object)e);
        }
        try {
            if (this.tcpServer != null) {
                this.tcpServer.stop();
                this.tcpServer = null;
            }
        }
        catch (Exception e) {
            logger.fatal((Object)e);
        }
    }
}

