/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.network.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.TCPServerCommand;
import jp.valtech.bts.network.server.Messages;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;

class TCPServer
implements Runnable,
Logging {
    private NetworkConfig myconfig = null;
    private ServerSocket serverSocket = null;

    public TCPServer(NetworkConfig myconfig) throws IOException {
        this.myconfig = myconfig;
        int port = myconfig.getTCPPort();
        this.serverSocket = new ServerSocket(port);
        logger.info((Object)(String.valueOf(Messages.getString("TCPServer.0")) + port + "}"));
    }

    public void run() {
        boolean active = true;
        while (active) {
            try {
                Socket socket = this.serverSocket.accept();
                ObjectInputStream is = new ObjectInputStream(socket.getInputStream());
                Request request = (Request)is.readObject();
                Object command = BTSUtility.getCommand(request.getCommand());
                if (command != null && command instanceof TCPServerCommand) {
                    TCPServerCommand tcpCommand = (TCPServerCommand)command;
                    tcpCommand.setRequest(request);
                    tcpCommand.setSocket(socket);
                    tcpCommand.setConfig(this.myconfig);
                    Thread t = new Thread((Runnable)tcpCommand, "TCPServerCommand");
                    t.start();
                    continue;
                }
                throw new ClassNotFoundException(Messages.getString("TCPServer.1"));
            }
            catch (SocketException socketException) {
                logger.info((Object)Messages.getString("TCPServer.2"));
                active = false;
            }
            catch (Exception e) {
                logger.error((Object)Messages.getString("TCPServer.3"), (Throwable)e);
            }
        }
        logger.info((Object)Messages.getString("TCPServer.4"));
    }

    public void stop() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
            this.serverSocket = null;
        }
    }
}

