/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.util.AttachmentUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;

public class DownloadIssueAttachmentAction
extends Action
implements Logging {
    private Attachment attachment;

    public DownloadIssueAttachmentAction() {
        this.setText(Messages.getString("DownloadIssueAttachmentAction.0"));
    }

    public void run() {
        try {
            FileDialog dialog = new FileDialog(BtsPlugin.getInstance().getShell(), 8192);
            dialog.setFileName(this.attachment.getDisplayName());
            String path = dialog.open();
            if (path == null || "".equals(path)) {
                return;
            }
            if (this.attachment.isRegisted()) {
                new AttachmentUtility().writeLocalFromWorkspace(this.attachment, path);
            } else {
                new AttachmentUtility().writeLocalFromLocal(this.attachment, path);
            }
        }
        catch (Exception e) {
            String msg = Messages.getString("DownloadIssueAttachmentAction.1");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }
}

