/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.editor;

import jp.valtech.bts.ui.editor.IssueDisplayValue;
import jp.valtech.bts.ui.editor.IssueMultiPageEditorInput;
import jp.valtech.bts.ui.editor.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractIssueEditorPart
extends EditorPart {
    protected FormToolkit toolkit;
    protected boolean dirty = false;
    protected IssueDisplayValue issueDisplayValue;
    protected static final Color COLOR_WHITE = Display.getDefault().getSystemColor(1);

    public void doSave(IProgressMonitor monitor) {
        this.dirty = false;
        this.firePropertyChange(257);
        this.fireIssueChange();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (!(input instanceof IssueMultiPageEditorInput)) {
            throw new PartInitException(Messages.getString("AbstractIssueEditorPart.0"));
        }
        IssueMultiPageEditorInput issueEditorInput = (IssueMultiPageEditorInput)input;
        this.issueDisplayValue = issueEditorInput.getIssueDisplayValue();
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    protected FormToolkit getFormToolkit(Composite composite) {
        if (this.toolkit == null) {
            this.toolkit = new FormToolkit(composite.getDisplay());
        }
        return this.toolkit;
    }

    protected Section createSection(Composite parent, String title) {
        if (this.toolkit == null) {
            this.getFormToolkit(parent);
        }
        Composite thisArea = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(1808));
        Section section = this.toolkit.createSection(thisArea, 458);
        section.setLayoutData((Object)new GridData(1808));
        if (title != null) {
            section.setText(title);
        }
        return section;
    }

    protected Text createText(Composite parent, String value, int style) {
        if (this.toolkit == null) {
            this.getFormToolkit(parent);
        }
        Text text = this.toolkit.createText(parent, value, style);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractIssueEditorPart.this.dirty = true;
                AbstractIssueEditorPart.this.firePropertyChange(257);
                AbstractIssueEditorPart.this.fireIssueChange();
            }
        });
        return text;
    }

    protected abstract void fireIssueChange();

    protected Text createText(Composite parent, String value) {
        return this.createText(parent, value, 0);
    }

    protected Combo createCombo(Composite parent, String[] values) {
        return this.createCombo(parent, values, "");
    }

    protected Combo createCombo(Composite parent, String[] values, String value) {
        if (this.toolkit == null) {
            this.getFormToolkit(parent);
        }
        Combo combo = new Combo(parent, 4);
        this.toolkit.adapt((Control)combo, true, true);
        int idx = 0;
        while (idx < values.length) {
            combo.add(values[idx]);
            ++idx;
        }
        combo.setText(value);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractIssueEditorPart.this.dirty = true;
                AbstractIssueEditorPart.this.firePropertyChange(257);
                AbstractIssueEditorPart.this.fireIssueChange();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractIssueEditorPart.this.dirty = true;
                AbstractIssueEditorPart.this.firePropertyChange(257);
                AbstractIssueEditorPart.this.fireIssueChange();
            }
        });
        return combo;
    }

    protected Button createRadio(Composite parent, String description, boolean selection) {
        if (this.toolkit == null) {
            this.getFormToolkit(parent);
        }
        Button radio = this.toolkit.createButton(parent, description, 16);
        radio.setSelection(selection);
        radio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractIssueEditorPart.this.dirty = true;
                AbstractIssueEditorPart.this.firePropertyChange(257);
                AbstractIssueEditorPart.this.fireIssueChange();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return radio;
    }

    protected Button createCheckBox(Composite parent, String description, boolean selection) {
        if (this.toolkit == null) {
            this.getFormToolkit(parent);
        }
        Button check = this.toolkit.createButton(parent, description, 32);
        check.setSelection(selection);
        check.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractIssueEditorPart.this.dirty = true;
                AbstractIssueEditorPart.this.firePropertyChange(257);
                AbstractIssueEditorPart.this.fireIssueChange();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return check;
    }

    public static void setStyle(StyledText text, String str, RGB rgb, int fontStyle) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = text.getText().length();
        styleRange.length = str.length();
        styleRange.foreground = new Color((Device)PlatformUI.getWorkbench().getDisplay(), rgb);
        styleRange.fontStyle = fontStyle;
        text.append(str);
        text.setStyleRange(styleRange);
    }
}

