/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.editor;

import jp.valtech.bts.data.Issue;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.editor.IssueDetailsExport;
import jp.valtech.bts.ui.editor.IssueMultiPageEditor;
import jp.valtech.bts.ui.editor.Messages;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IssueDetailsExportDialog
extends Dialog
implements Logging {
    Text headerTxt;
    Text footerTxt;
    Button fileHTMRdi;
    private Button filePDFRdi;
    Button fileXMLRdi;
    private Button fileCSVRdi;
    TableViewer attachViewer;
    private IssueMultiPageEditor parentEditor;

    public IssueDetailsExportDialog(Shell parentShell, TableViewer attachViewer, IssueMultiPageEditor parentEditor) {
        super(parentShell);
        this.attachViewer = attachViewer;
        this.parentEditor = parentEditor;
    }

    public IssueDetailsExportDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("IssueDetailsExportDialog.0"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.createFileFormatArea(composite);
            this.createHeaderArea(composite);
            this.createSeparatorLine(composite);
        }
        catch (Exception e) {
            String msg = Messages.getString("IssueDetailsExportDialog.9");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
        return composite;
    }

    private void createFileFormatArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        thisArea.setLayoutData((Object)new GridData(768));
        Group group = new Group(thisArea, 0);
        group.setText(Messages.getString("IssueDetailsExportDialog.1"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.fileHTMRdi = new Button((Composite)group, 16);
        this.fileHTMRdi.setText("HTML");
        this.fileXMLRdi = new Button((Composite)group, 16);
        this.fileXMLRdi.setText("XML");
        this.filePDFRdi = new Button((Composite)group, 16);
        this.filePDFRdi.setText("PDF");
        this.filePDFRdi.setEnabled(false);
        this.fileCSVRdi = new Button((Composite)group, 16);
        this.fileCSVRdi.setText("CSV");
        this.fileCSVRdi.setEnabled(false);
    }

    private void createHeaderArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData(4);
        gridData.widthHint = 220;
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueDetailsExportDialog.2"));
        this.headerTxt = new Text(thisArea, 2048);
        this.headerTxt.setLayoutData((Object)new GridData(768));
        this.headerTxt.setLayoutData((Object)gridData);
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("IssueDetailsExportDialog.3"));
        this.footerTxt = new Text(thisArea, 2048);
        this.footerTxt.setLayoutData((Object)new GridData(768));
        this.footerTxt.setLayoutData((Object)gridData);
    }

    private void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setLayoutData((Object)gd);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.getString("IssueDetailsExportDialog.4"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        String[] filterNames;
        String[] extensions;
        String extension;
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        if (this.fileHTMRdi.getSelection()) {
            extension = ".html";
            extensions = new String[]{"*.html", "*.*"};
            fileDialog.setFilterExtensions(extensions);
            filterNames = new String[]{Messages.getString("IssueDetailsExportDialog.5"), Messages.getString("IssueDetailsExportDialog.6")};
            fileDialog.setFilterNames(filterNames);
        } else {
            extension = ".xml";
            extensions = new String[]{"*.xml", "*.*"};
            fileDialog.setFilterExtensions(extensions);
            filterNames = new String[]{Messages.getString("IssueDetailsExportDialog.7"), Messages.getString("IssueDetailsExportDialog.8")};
            fileDialog.setFilterNames(filterNames);
        }
        Issue issue = this.parentEditor.getModifiedIssue();
        fileDialog.setFileName(String.valueOf(issue.getTitle()) + extension);
        String fileName = fileDialog.open();
        String filterPath = fileDialog.getFilterPath();
        if (fileName == null) {
            return;
        }
        IssueDetailsExport issueDetailsExport = new IssueDetailsExport(this, fileName, filterPath);
        issueDetailsExport.exportRun();
        super.okPressed();
    }
}

