/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueStatus;
import jp.valtech.bts.facade.VoteDAOFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.DownloadIssueAttachmentAction;
import jp.valtech.bts.ui.action.OpenCalendarDlgAction;
import jp.valtech.bts.ui.action.OpenDetailsExportDlgAction;
import jp.valtech.bts.ui.action.OpenProjectConfigDlgAction;
import jp.valtech.bts.ui.action.OpenVoteDlgAction;
import jp.valtech.bts.ui.action.SaveIssueAction;
import jp.valtech.bts.ui.action.SendReleaseIssueAction;
import jp.valtech.bts.ui.editor.AbstractIssueEditorPart;
import jp.valtech.bts.ui.editor.IssueMultiPageEditor;
import jp.valtech.bts.ui.editor.IssueMultiPageEditorInput;
import jp.valtech.bts.ui.editor.Messages;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.IssueUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.WorkbenchPart;

public class OverviewPart
extends AbstractIssueEditorPart
implements Logging {
    public static final String TAB_TITLE = Messages.getString("OverviewPart.0");
    private static final Image IMAGE_DEADLINE_WORNING = BtsPlugin.getInstance().getImage("warning1.gif");
    private static final Image IMAGE_DEADLINE_ERROR = BtsPlugin.getInstance().getImage("error1.gif");
    private static final int WITH_LABEL_S = 55;
    private static final int WITH_LABEL_L = 250;
    private static final int WITH_TEXT_S = 70;
    private static final int WITH_TEXT_M = 120;
    private static final int WIDTH_BUTTON_M = 60;
    private static final int WIDTH_PAIN = 430;
    private static final int WIDTH_TEXT_L = 300;
    private static final int HEIGHT_TEXT_L = 170;
    private static final int HEIGHT_BUTTON_S = 20;
    private GridData labelSizeS;
    private GridData labelSizeL;
    private GridData labelSizeMB;
    private GridData textSizeS;
    private GridData textSizeM;
    private GridData textSizeL;
    private GridData textSizeLL;
    private GridData comboSizeM;
    private GridData buttonSizeSS;
    private GridData buttonSizeM;
    private Label createUserLbl;
    private Label createDateLbl;
    private Label updateDateLbl;
    private Label versionLbl;
    private CLabel issueIdLbl;
    private Text titleTxt;
    private Text descTxt;
    private Combo categoryCmb;
    private Combo priorityCmb;
    private Combo userNameCmb;
    private Label userNameLbl;
    private List statusRdiList = new ArrayList();
    private Button stClosedRdi;
    private Text deadLineTxt;
    private Button secretChk;
    private Button suspendChk;
    private Label limitLabelImg;
    private Label limitLabel;
    public TableViewer attachViewer;
    private ScrolledForm form;
    private OpenDetailsExportDlgAction openDetailsExportDlgAction;
    private SendReleaseIssueAction sendIssueCmdAction;
    private SaveIssueAction saveIssueAction;
    private OpenProjectConfigDlgAction editPullDownMenuAction;
    private RemoveAttachmentAction removeAttachmentAction;
    ImageHyperlink voteLink;
    IssueMultiPageEditor parentEditor;

    public OverviewPart(IssueMultiPageEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    public void createPartControl(Composite parent) {
        try {
            this.makeActions();
            if (this.toolkit == null) {
                this.getFormToolkit(parent);
            }
            this.createCommonLayout();
            Composite body = this.createBody(parent);
            GridLayout bodyLayout = new GridLayout();
            bodyLayout.marginHeight = 0;
            bodyLayout.marginWidth = 0;
            GridData grid = new GridData(768);
            grid.verticalSpan = 3;
            grid.verticalAlignment = 1;
            grid.minimumWidth = 430;
            Composite generalSection = this.toolkit.createComposite(body);
            generalSection.setLayout((Layout)bodyLayout);
            generalSection.setLayoutData((Object)grid);
            this.createGeneralSection(generalSection);
            grid = new GridData(768);
            grid.verticalAlignment = 1;
            Composite optionSection = this.toolkit.createComposite(body);
            optionSection.setLayout((Layout)bodyLayout);
            optionSection.setLayoutData((Object)grid);
            this.createOptionSection(optionSection);
            grid = new GridData(768);
            grid.verticalAlignment = 1;
            Composite updInfoSection = this.toolkit.createComposite(body);
            updInfoSection.setLayout((Layout)bodyLayout);
            updInfoSection.setLayoutData((Object)grid);
            this.createUpdateInfoSection(updInfoSection);
            this.changeActivate();
            this.form.reflow(false);
        }
        catch (Exception e) {
            String msg = Messages.getString("OverviewPart.1");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    private void makeActions() {
        this.openDetailsExportDlgAction = new OpenDetailsExportDlgAction(this, this.parentEditor);
        IssueMultiPageEditorInput issueEditorInput = (IssueMultiPageEditorInput)this.getEditorInput();
        if (issueEditorInput.getOpenMode() == 0) {
            this.openDetailsExportDlgAction.setEnabled(false);
        }
        this.sendIssueCmdAction = new SendReleaseIssueAction();
        this.saveIssueAction = new SaveIssueAction();
        this.saveIssueAction.setEnabled(false);
        this.editPullDownMenuAction = new OpenProjectConfigDlgAction((IEditorPart)this);
        this.removeAttachmentAction = new RemoveAttachmentAction();
    }

    private Composite createBody(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText(Messages.getString("OverviewPart.2"));
        this.form.getBody().setLayout((Layout)layout);
        this.form.getBody().setLayoutData((Object)new GridData(1808));
        this.form.getToolBarManager().add((IAction)this.sendIssueCmdAction);
        this.form.getToolBarManager().add((IAction)this.saveIssueAction);
        this.form.getToolBarManager().add((IAction)this.openDetailsExportDlgAction);
        this.form.updateToolBar();
        Composite body = this.toolkit.createComposite(this.form.getBody());
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 2;
        body.setLayout((Layout)layout);
        body.setLayoutData((Object)new GridData(1808));
        return body;
    }

    private void createCommonLayout() {
        this.labelSizeS = new GridData();
        this.labelSizeS.widthHint = 55;
        this.labelSizeL = new GridData(768);
        this.labelSizeL.widthHint = 250;
        this.labelSizeMB = new GridData();
        this.labelSizeMB.widthHint = 55;
        this.labelSizeMB.verticalAlignment = 1;
        this.buttonSizeSS = new GridData();
        this.buttonSizeSS.heightHint = 20;
        this.buttonSizeM = new GridData();
        this.buttonSizeM.widthHint = 60;
        this.textSizeM = new GridData();
        this.textSizeM.widthHint = 120;
        this.textSizeS = new GridData();
        this.textSizeS.widthHint = 70;
        this.textSizeL = new GridData(768);
        this.textSizeL.widthHint = 300;
        this.textSizeLL = new GridData(768);
        this.textSizeLL.heightHint = 170;
        this.textSizeLL.widthHint = 300;
        this.comboSizeM = new GridData();
        this.comboSizeM.widthHint = 120;
    }

    private void createUpdateInfoSection(Composite parent) {
        Section section = this.createSection(parent, Messages.getString("OverviewPart.3"));
        section.setDescription(Messages.getString("OverviewPart.4"));
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)composite);
        this.createTimeStampArea(composite);
    }

    private void createOptionSection(Composite parent) {
        Section section = this.createSection(parent, Messages.getString("OverviewPart.5"));
        section.setDescription(Messages.getString("OverviewPart.6"));
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)composite);
        this.createDeadLineArea(composite);
        this.createOptionStArea(composite);
        this.createAttachmentArea(composite);
    }

    private void createGeneralSection(Composite parent) throws BtsDBException {
        int warningCnt;
        Section section = this.createSection(parent, Messages.getString("OverviewPart.7"));
        section.setDescription(Messages.getString("OverviewPart.8"));
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)composite);
        this.voteLink = new ImageHyperlink((Composite)section, 0);
        this.getFormToolkit(parent).adapt((Control)this.voteLink, true, true);
        this.voteLink.setImage(BtsPlugin.getInstance().getImage("vote.gif"));
        this.voteLink.setBackground(section.getTitleBarGradientBackground());
        this.voteLink.setToolTipText(Messages.getString("OverviewPart.9"));
        VoteDAOFacade voteDAOFacade = new VoteDAOFacade();
        int voteSum = voteDAOFacade.getSum(this.issueDisplayValue.getIssue().getFingerPrint());
        String voteStr = String.valueOf(Messages.getString("OverviewPart.40")) + voteSum + Messages.getString("OverviewPart.41");
        this.voteLink.setForeground(null);
        this.voteLink.setFont(null);
        ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
        if (config.isVoteCheck() && voteSum > (warningCnt = Integer.parseInt(config.getVote()))) {
            voteStr = String.valueOf(Messages.getString("OverviewPart.42")) + voteSum + Messages.getString("OverviewPart.43");
            this.voteLink.setForeground(new Color((Device)Display.getCurrent(), 255, 0, 0));
            this.voteLink.setFont(new Font((Device)Display.getCurrent(), "", 10, 1));
        }
        this.voteLink.setText(voteStr);
        this.voteLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenVoteDlgAction action = new OpenVoteDlgAction((WorkbenchPart)OverviewPart.this, OverviewPart.this.voteLink);
                action.setIssue(OverviewPart.this.issueDisplayValue.getIssue());
                action.run();
            }
        });
        section.setTextClient((Control)this.voteLink);
        this.createIssueIDArea(composite);
        this.createCategoryArea(composite);
        this.createTitleArea(composite);
        this.createDescriptionArea(composite);
        this.createPriorityArea(composite);
        this.createStatusArea(composite);
    }

    private void createAttachmentArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.10"), 131072);
        label.setLayoutData((Object)this.labelSizeMB);
        Composite right = this.toolkit.createComposite(thisArea);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        right.setLayout((Layout)layout);
        right.setLayoutData((Object)new GridData(768));
        this.createAttachementTblArea(right);
        this.createAttachementBtnArea(right);
    }

    private void createAttachementBtnArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 1;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Button addAttachment = this.toolkit.createButton(thisArea, Messages.getString("OverviewPart.11"), 8);
        addAttachment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(BtsPlugin.getInstance().getShell(), 4096);
                String path = dialog.open();
                if (path == null || "".equals(path)) {
                    return;
                }
                File file = new File(path);
                if (!file.exists()) {
                    return;
                }
                IssueMultiPageEditorInput issueEditorInput = (IssueMultiPageEditorInput)OverviewPart.this.getEditorInput();
                Issue issue = issueEditorInput.getIssue();
                Attachment attachment = new Attachment();
                attachment.setFingerPrint(issue.getFingerPrint());
                attachment.setType(issue.getType());
                attachment.setRealPath(path);
                attachment.setDisplayName(file.getName());
                attachment.setRegisted(false);
                ((List)OverviewPart.this.attachViewer.getInput()).add(attachment);
                OverviewPart.this.attachViewer.insert((Object)attachment, -1);
                OverviewPart.this.dirty = true;
                OverviewPart.this.firePropertyChange(257);
                OverviewPart.this.fireIssueChange();
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Attachment attachment = OverviewPart.this.getSelectionRecord();
                if (attachment != null) {
                    DownloadIssueAttachmentAction action = new DownloadIssueAttachmentAction();
                    action.setAttachment(attachment);
                    manager.add((IAction)action);
                    manager.add((IAction)OverviewPart.this.removeAttachmentAction);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.attachViewer.getControl());
        this.attachViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.attachViewer);
    }

    private Attachment getSelectionRecord() {
        ISelection selection = this.attachViewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof Attachment) {
            return (Attachment)obj;
        }
        return null;
    }

    private void createAttachementTblArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Table table = new Table(thisArea, 66048);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        TableColumn col1 = new TableColumn(table, 0, 0);
        col1.setText(Messages.getString("OverviewPart.12"));
        this.attachViewer = new TableViewer(table);
        GridData tableGrid = new GridData();
        tableGrid.heightHint = 60;
        tableGrid.widthHint = 200;
        this.attachViewer.getControl().setLayoutData((Object)tableGrid);
        this.attachViewer.setContentProvider((IContentProvider)new AttachementTableContentProvider());
        this.attachViewer.setLabelProvider((IBaseLabelProvider)new AttachementTableLabelProvider());
        this.hookContextMenu();
        this.attachViewer.setInput((Object)this.issueDisplayValue.getAttachmentList());
    }

    private void createOptionStArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        layout.marginHeight = 4;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.13"), 131072);
        GridData gridData = new GridData();
        gridData.widthHint = 55;
        gridData.verticalAlignment = 1;
        gridData.verticalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.secretChk = this.createCheckBox(thisArea, Messages.getString("OverviewPart.14"), this.issueDisplayValue.isSecretBug());
        this.suspendChk = this.createCheckBox(thisArea, Messages.getString("OverviewPart.15"), this.issueDisplayValue.isSuspend());
    }

    private void createDeadLineArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.marginHeight = 0;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.16"), 131072);
        label.setLayoutData((Object)this.labelSizeS);
        this.deadLineTxt = this.createText(thisArea, this.issueDisplayValue.getDeadline());
        this.deadLineTxt.setLayoutData((Object)this.textSizeS);
        ImageHyperlink calendarLink = new ImageHyperlink(thisArea, 0);
        calendarLink.setImage(BtsPlugin.getInstance().getImage("calendar.gif"));
        calendarLink.setBackground(COLOR_WHITE);
        calendarLink.setToolTipText(Messages.getString("OverviewPart.17"));
        calendarLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenCalendarDlgAction action = new OpenCalendarDlgAction(OverviewPart.this.deadLineTxt);
                action.run();
            }
        });
        String deadLineStr = this.deadLineTxt.getText().trim();
        this.limitLabelImg = this.toolkit.createLabel(thisArea, "");
        this.limitLabelImg.setLayoutData((Object)new GridData(128));
        this.limitLabel = this.toolkit.createLabel(thisArea, "");
        GridData data = new GridData();
        this.limitLabel.setLayoutData((Object)data);
        int judge = BTSUtility.judgeLimit(BTSUtility.createDate(deadLineStr), this.getIssueStatus().getValue());
        this.setDeadLineMessage(judge);
    }

    private void setDeadLineMessage(int judge) {
        if (judge == 2) {
            this.limitLabelImg.setImage(IMAGE_DEADLINE_ERROR);
            this.limitLabel.setText(Messages.getString("OverviewPart.44"));
            this.limitLabel.setForeground(new Color((Device)Display.getCurrent(), 255, 0, 0));
        } else if (judge == 1) {
            this.limitLabelImg.setImage(IMAGE_DEADLINE_WORNING);
            this.limitLabel.setText(Messages.getString("OverviewPart.45"));
            this.limitLabel.setForeground(new Color((Device)Display.getCurrent(), 0, 0, 255));
        } else if (judge == 0) {
            this.limitLabelImg.setImage(null);
            this.limitLabelImg.setText("    ");
            this.limitLabel.setText("                               ");
        }
    }

    private void createStatusArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.verticalSpacing = 0;
        layout.marginHeight = 4;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.19"), 131072);
        GridData gridData = new GridData();
        gridData.widthHint = 55;
        gridData.verticalAlignment = 1;
        gridData.verticalSpan = 5;
        label.setLayoutData((Object)gridData);
        GridData colspan = new GridData();
        colspan.horizontalSpan = 3;
        Button stOpenedRdi = this.createRadio(thisArea, IssueStatus.OPENED.getDescription(), this.issueDisplayValue.isStatusOpened());
        stOpenedRdi.setLayoutData((Object)colspan);
        this.statusRdiList.add(stOpenedRdi);
        Button stAssignedRdi = this.createRadio(thisArea, IssueStatus.ASSIGNED.getDescription(), this.issueDisplayValue.isStatusAssigned());
        this.statusRdiList.add(stAssignedRdi);
        this.userNameLbl = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.20"), 131072);
        this.userNameCmb = this.createCombo(thisArea, IssueUtility.getAssigned(), this.issueDisplayValue.getAssigned());
        this.userNameCmb.setLayoutData((Object)this.comboSizeM);
        this.userNameCmb.setTextLimit(20);
        stAssignedRdi.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button assigned = (Button)e.widget;
                if (assigned.getSelection()) {
                    OverviewPart.this.userNameCmb.setEnabled(true);
                    OverviewPart.this.userNameLbl.setEnabled(true);
                } else {
                    OverviewPart.this.userNameCmb.setEnabled(false);
                    OverviewPart.this.userNameLbl.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (!stAssignedRdi.getSelection()) {
            this.userNameCmb.setEnabled(false);
            this.userNameLbl.setEnabled(false);
        }
        Button stResolvedRdi = this.createRadio(thisArea, IssueStatus.RESOLVED.getDescription(), this.issueDisplayValue.isStatusResolved());
        stResolvedRdi.setLayoutData((Object)colspan);
        this.statusRdiList.add(stResolvedRdi);
        Button stVerifiedRdi = this.createRadio(thisArea, IssueStatus.VERIFIED.getDescription(), this.issueDisplayValue.isStatusVerified());
        stVerifiedRdi.setLayoutData((Object)colspan);
        this.statusRdiList.add(stVerifiedRdi);
        this.stClosedRdi = this.createRadio(thisArea, IssueStatus.CLOSED.getDescription(), this.issueDisplayValue.isStatusClosed());
        this.stClosedRdi.setLayoutData((Object)colspan);
        this.statusRdiList.add(this.stClosedRdi);
    }

    private void createPriorityArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.21"), 131072);
        label.setLayoutData((Object)this.labelSizeS);
        this.priorityCmb = this.createCombo(thisArea, IssueUtility.getPriorities(), this.issueDisplayValue.getPriority());
        this.priorityCmb.setLayoutData((Object)this.comboSizeM);
        this.priorityCmb.setTextLimit(20);
    }

    private void createDescriptionArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.22"), 131072);
        label.setLayoutData((Object)this.labelSizeMB);
        this.descTxt = this.createText(thisArea, this.issueDisplayValue.getDescription(), 770);
        this.descTxt.setLayoutData((Object)this.textSizeLL);
    }

    private void createTitleArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.23"), 131072);
        label.setLayoutData((Object)this.labelSizeS);
        this.titleTxt = this.createText(thisArea, this.issueDisplayValue.getTitle());
        this.titleTxt.setLayoutData((Object)this.textSizeL);
        this.titleTxt.setTextLimit(45);
    }

    private void createCategoryArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 1;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.24"), 131072);
        label.setLayoutData((Object)this.labelSizeS);
        this.categoryCmb = this.createCombo(thisArea, IssueUtility.getCategories(), this.issueDisplayValue.getCategory());
        this.categoryCmb.setLayoutData((Object)this.comboSizeM);
        this.categoryCmb.setTextLimit(20);
        Link link = new Link(thisArea, 0);
        link.setText(Messages.getString("OverviewPart.25"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverviewPart.this.editPullDownMenuAction.run();
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 5;
        link.setLayoutData((Object)gridData);
        link.setBackground(COLOR_WHITE);
    }

    private void createIssueIDArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.26"), 131072);
        label.setLayoutData((Object)this.labelSizeS);
        this.issueIdLbl = new CLabel(thisArea, 16384);
        this.issueIdLbl.setText(this.issueDisplayValue.getDisplayIssueID());
        this.issueIdLbl.setBackground(COLOR_WHITE);
        this.issueIdLbl.setLayoutData((Object)this.labelSizeL);
    }

    private void createTimeStampArea(Composite composite) {
        Composite thisArea = this.toolkit.createComposite(composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        thisArea.setLayout((Layout)layout);
        thisArea.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.27"), 131072);
        label.setLayoutData((Object)this.labelSizeS);
        this.createUserLbl = this.toolkit.createLabel(thisArea, this.issueDisplayValue.getCreateUser());
        this.createUserLbl.setLayoutData((Object)new GridData(768));
        label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.28"), 131072);
        label.setLayoutData((Object)this.labelSizeS);
        this.createDateLbl = this.toolkit.createLabel(thisArea, this.issueDisplayValue.getCreateDate());
        this.createDateLbl.setLayoutData((Object)new GridData(768));
        label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.29"), 131072);
        label.setLayoutData((Object)this.labelSizeS);
        this.updateDateLbl = this.toolkit.createLabel(thisArea, this.issueDisplayValue.getUpdateDate());
        this.updateDateLbl.setLayoutData((Object)new GridData(768));
        label = this.toolkit.createLabel(thisArea, Messages.getString("OverviewPart.30"), 131072);
        label.setLayoutData((Object)this.labelSizeS);
        this.versionLbl = this.toolkit.createLabel(thisArea, this.issueDisplayValue.getVersion());
        this.versionLbl.setLayoutData((Object)new GridData(768));
        Link link = new Link(thisArea, 0);
        link.setText(Messages.getString("OverviewPart.31"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverviewPart.this.parentEditor.changeHistoryPage();
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 5;
        link.setLayoutData((Object)gridData);
        link.setBackground(COLOR_WHITE);
    }

    private IssueStatus getIssueStatus() {
        int idx = 0;
        while (idx < this.statusRdiList.size()) {
            Button statusRdi = (Button)this.statusRdiList.get(idx);
            if (statusRdi.getSelection()) {
                String description = statusRdi.getText();
                return IssueStatus.getEnumByDescription(description);
            }
            ++idx;
        }
        throw new RuntimeException(Messages.getString("OverviewPart.32"));
    }

    public void postSave(Issue savedIssue) {
        IssueMultiPageEditorInput issueEditorInput = (IssueMultiPageEditorInput)this.getEditorInput();
        issueEditorInput.resetIssue(savedIssue);
        this.versionLbl.setText(this.issueDisplayValue.getVersion());
        this.updateDateLbl.setText(this.issueDisplayValue.getUpdateDate());
        this.createDateLbl.setText(this.issueDisplayValue.getCreateDate());
        this.createUserLbl.setText(this.issueDisplayValue.getCreateUser());
        int issueID = savedIssue.getIssueID();
        if (issueID != 0) {
            this.issueIdLbl.setText(savedIssue.getDisplayIssueID());
        }
        int judge = BTSUtility.judgeLimit(savedIssue);
        this.setDeadLineMessage(judge);
        this.changeActivate();
        this.dirty = false;
        this.firePropertyChange(257);
        this.fireIssueChange();
    }

    private void changeActivate() {
        String type = this.issueDisplayValue.getIssue().getType();
        if (type.equals("R")) {
            this.sendIssueCmdAction.setEnabled(true);
            this.voteLink.setEnabled(true);
            this.openDetailsExportDlgAction.setEnabled(true);
        } else if (type.equals("D")) {
            this.sendIssueCmdAction.setEnabled(true);
            this.voteLink.setEnabled(false);
            this.openDetailsExportDlgAction.setEnabled(false);
        } else if (type.equals("C")) {
            this.saveIssueAction.setEnabled(false);
            this.sendIssueCmdAction.setEnabled(false);
            this.voteLink.setEnabled(false);
            this.openDetailsExportDlgAction.setEnabled(true);
        } else if (type.equals("G")) {
            this.saveIssueAction.setEnabled(false);
            this.sendIssueCmdAction.setEnabled(false);
            this.voteLink.setEnabled(false);
            this.openDetailsExportDlgAction.setEnabled(true);
        }
    }

    private boolean validate() {
        Date date;
        String category = this.categoryCmb.getText().trim();
        if (category.equals("")) {
            MessageDialog.openError((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("OverviewPart.33"), (String)Messages.getString("OverviewPart.34"));
            return false;
        }
        String title = this.titleTxt.getText().trim();
        if (title.equals("")) {
            MessageDialog.openError((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("OverviewPart.35"), (String)Messages.getString("OverviewPart.36"));
            return false;
        }
        String deadLine = this.deadLineTxt.getText().trim();
        if (!deadLine.equals("") && (date = BTSUtility.createDate(this.deadLineTxt.getText())) == null) {
            MessageDialog.openError((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("OverviewPart.37"), (String)Messages.getString("OverviewPart.38"));
            return false;
        }
        return true;
    }

    Issue getModifiedIssue() {
        if (!this.validate()) {
            return null;
        }
        Issue newIssue = new Issue();
        Issue oldIssue = this.issueDisplayValue.getIssue();
        newIssue.setCategory(this.categoryCmb.getText());
        newIssue.setTitle(this.titleTxt.getText());
        newIssue.setDescription(this.descTxt.getText());
        newIssue.setPriority(this.priorityCmb.getText());
        newIssue.setStatus(this.getIssueStatus().getValue());
        newIssue.setAssigned(this.userNameCmb.getText());
        newIssue.setSecretBug(this.secretChk.getSelection());
        newIssue.setSuspend(this.suspendChk.getSelection());
        newIssue.setDeadline(BTSUtility.createDate(this.deadLineTxt.getText()));
        newIssue.setCreateUser(oldIssue.getCreateUser());
        newIssue.setCreateDate(oldIssue.getCreateDate());
        newIssue.setUpdateDate(oldIssue.getUpdateDate());
        newIssue.setIssueID(oldIssue.getIssueID());
        newIssue.setType(oldIssue.getType());
        newIssue.setVersion(oldIssue.getVersion());
        if (oldIssue.getFingerPrint() == null || "".equals(oldIssue.getFingerPrint())) {
            IssueUtility.createFingerPrint(newIssue);
        } else {
            newIssue.setFingerPrint(oldIssue.getFingerPrint());
        }
        newIssue.setAttachmentList((ArrayList)this.attachViewer.getInput());
        return newIssue;
    }

    protected void fireIssueChange() {
        String type = this.issueDisplayValue.getIssue().getType();
        if (type.equals("R")) {
            this.saveIssueAction.setEnabled(this.dirty);
        } else if (type.equals("D")) {
            this.saveIssueAction.setEnabled(this.dirty);
        } else if (!type.equals("C")) {
            type.equals("G");
        }
    }

    public void setFocus() {
        this.titleTxt.setFocus();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private class AttachementTableContentProvider
    implements IStructuredContentProvider {
        AttachementTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class AttachementTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AttachementTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Attachment attach = (Attachment)element;
            switch (columnIndex) {
                case 0: {
                    return attach.getDisplayName();
                }
            }
            return "";
        }
    }

    private class RemoveAttachmentAction
    extends Action {
        RemoveAttachmentAction() {
            this.setText(Messages.getString("OverviewPart.39"));
        }

        public void run() {
            Attachment attachment = OverviewPart.this.getSelectionRecord();
            if (attachment != null) {
                ((List)OverviewPart.this.attachViewer.getInput()).remove(attachment);
                OverviewPart.this.attachViewer.remove((Object)attachment);
                OverviewPart.this.dirty = true;
                OverviewPart.this.firePropertyChange(257);
                OverviewPart.this.fireIssueChange();
            }
        }
    }
}

