/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.issuelist;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.issuelist.IssueListView;
import jp.valtech.bts.ui.issuelist.Messages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Table;

public class IssueListViewFilter {
    private IssueListView view;
    private TableViewer viewer;
    private IDialogSettings section = BtsPlugin.getInstance().getDialogSettings().getSection("IssueFilter");

    public IssueListViewFilter(IssueListView view) {
        this.view = view;
        this.viewer = view.getViewer();
    }

    public void addIssueFilters() {
        int i;
        if (this.section == null) {
            return;
        }
        ViewerFilter[] filters = this.viewer.getFilters();
        if (filters != null) {
            int i2 = 0;
            while (i2 < filters.length) {
                if (!(filters[i2] instanceof TreeSelectionFilter)) {
                    this.viewer.removeFilter(filters[i2]);
                }
                ++i2;
            }
        }
        if (!"".equals(this.section.get("ISSUEID"))) {
            this.viewer.addFilter((ViewerFilter)new IssueIdFilter());
        }
        if (!"".equals(this.section.get("FROM")) && !"".equals(this.section.get("TO"))) {
            this.viewer.addFilter((ViewerFilter)new DateFromFilter());
            this.viewer.addFilter((ViewerFilter)new DateToFilter());
        } else if (!"".equals(this.section.get("FROM")) && "".equals(this.section.get("TO"))) {
            this.viewer.addFilter((ViewerFilter)new DateFromFilter());
        } else if ("".equals(this.section.get("FROM")) && !"".equals(this.section.get("TO"))) {
            this.viewer.addFilter((ViewerFilter)new DateToFilter());
        }
        if (!"".equals(this.section.get("TITLE"))) {
            this.viewer.addFilter((ViewerFilter)new TitleFilter());
        }
        if (!"".equals(this.section.get("DESC"))) {
            this.viewer.addFilter((ViewerFilter)new DescFilter());
        }
        if (!"".equals(this.section.get("ASSIGNED"))) {
            String[] assignedNames = this.section.get("ASSIGNED").split("\\|");
            i = 0;
            while (i < assignedNames.length) {
                this.viewer.addFilter((ViewerFilter)new AssignedFilter(assignedNames[i]));
                ++i;
            }
        }
        if (!"".equals(this.section.get("PRIORITY"))) {
            String[] priorityNames = this.section.get("PRIORITY").split("\\|");
            i = 0;
            while (i < priorityNames.length) {
                this.viewer.addFilter((ViewerFilter)new PriorityFilter(priorityNames[i]));
                ++i;
            }
        }
        if (!this.section.getBoolean("STOPEN")) {
            this.viewer.addFilter((ViewerFilter)new StatusFilter("1"));
        }
        if (!this.section.getBoolean("STASSIGNED")) {
            this.viewer.addFilter((ViewerFilter)new StatusFilter("2"));
        }
        if (!this.section.getBoolean("STRESOLVED")) {
            this.viewer.addFilter((ViewerFilter)new StatusFilter("3"));
        }
        if (!this.section.getBoolean("STVERIFIED")) {
            this.viewer.addFilter((ViewerFilter)new StatusFilter("4"));
        }
        if (!this.section.getBoolean("STCLOSED")) {
            this.viewer.addFilter((ViewerFilter)new StatusFilter("5"));
        }
        if (!this.section.getBoolean("SECRET")) {
            this.viewer.addFilter((ViewerFilter)new SecretBugFilter());
        }
        if (!this.section.getBoolean("RESERVE")) {
            this.viewer.addFilter((ViewerFilter)new ReserveIssueFilter());
        }
        if (!this.section.getBoolean("DEADLINE")) {
            this.viewer.addFilter((ViewerFilter)new DeadLineFilter());
        }
        Table table = this.viewer.getTable();
        this.view.updateDescription(table.getItemCount());
    }

    public void setCategoryFilter(String category) {
        this.clearTreeSelectionFilter();
        this.viewer.addFilter((ViewerFilter)new IssueTypeFilter("R"));
        this.viewer.addFilter((ViewerFilter)new CategoryFilter(category));
        Table table = this.viewer.getTable();
        this.view.updateDescription(table.getItemCount());
    }

    public void setIssueTypeFilter(String issueType) {
        this.clearTreeSelectionFilter();
        this.viewer.addFilter((ViewerFilter)new IssueTypeFilter(issueType));
        Table table = this.viewer.getTable();
        this.view.updateDescription(table.getItemCount());
    }

    public void setClearFilter() {
        this.clearTreeSelectionFilter();
        this.viewer.addFilter((ViewerFilter)new ClearFilter());
        this.view.updateDescription(0);
    }

    private void clearTreeSelectionFilter() {
        ViewerFilter[] filters = this.viewer.getFilters();
        if (filters == null) {
            return;
        }
        int i = 0;
        while (i < filters.length) {
            if (filters[i] instanceof TreeSelectionFilter) {
                this.viewer.removeFilter(filters[i]);
            }
            ++i;
        }
    }

    private class IssueIdFilter
    extends ViewerFilter {
        IssueIdFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return IssueListViewFilter.this.section.get("ISSUEID").equals(((Issue)element).getDisplayIssueID());
        }
    }

    private class DateFromFilter
    extends ViewerFilter {
        DateFromFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if ("".equals(IssueListViewFilter.this.section.get("FROM"))) {
                return true;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            Date fromDate = null;
            try {
                fromDate = new Date(dateFormat.parse(IssueListViewFilter.this.section.get("FROM")).getTime());
            }
            catch (ParseException e) {
                BtsPlugin.getInstance().errorlog(e);
            }
            Date timestamp = new Date(((Issue)element).getCreateDateTimestamp());
            return timestamp.after(fromDate);
        }
    }

    private class DateToFilter
    extends ViewerFilter {
        DateToFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if ("".equals(IssueListViewFilter.this.section.get("TO"))) {
                return true;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            Date toDate = null;
            try {
                toDate = new Date(dateFormat.parse(IssueListViewFilter.this.section.get("TO")).getTime() + 86400000L);
            }
            catch (ParseException e) {
                BtsPlugin.getInstance().errorlog(e);
            }
            Date timestamp = new Date(((Issue)element).getCreateDateTimestamp());
            return timestamp.before(toDate);
        }
    }

    private class TitleFilter
    extends ViewerFilter {
        TitleFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            int index = ((Issue)element).getTitle().indexOf(IssueListViewFilter.this.section.get("TITLE"));
            if (Messages.getString("IssueListViewFilter.0").equals(IssueListViewFilter.this.section.get("TITLECOMBO"))) {
                return index != -1;
            }
            return index == -1;
        }
    }

    private class DescFilter
    extends ViewerFilter {
        DescFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String desc = ((Issue)element).getDescription();
            if (desc == null) {
                desc = "";
            }
            int index = desc.indexOf(IssueListViewFilter.this.section.get("DESC"));
            if (Messages.getString("IssueListViewFilter.1").equals(IssueListViewFilter.this.section.get("DESCCOMBO"))) {
                return index != -1;
            }
            return index == -1;
        }
    }

    private class AssignedFilter
    extends ViewerFilter {
        private String assignedName;

        AssignedFilter(String assignedName) {
            this.assignedName = assignedName;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !this.assignedName.equals(((Issue)element).getAssigned());
        }
    }

    private class PriorityFilter
    extends ViewerFilter {
        private String priorityName;

        PriorityFilter(String priorityName) {
            this.priorityName = priorityName;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !this.priorityName.equals(((Issue)element).getPriority());
        }
    }

    private class StatusFilter
    extends ViewerFilter {
        private String value;

        StatusFilter(String value) {
            this.value = value;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !this.value.equals(((Issue)element).getStatus());
        }
    }

    private class SecretBugFilter
    extends ViewerFilter {
        SecretBugFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return ((Issue)element).isSecretBug() == false;
        }
    }

    private class ReserveIssueFilter
    extends ViewerFilter {
        ReserveIssueFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return ((Issue)element).isSuspend() == false;
        }
    }

    private class DeadLineFilter
    extends ViewerFilter {
        DeadLineFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Date nowStamp = new Date();
            if (((Issue)element).getDeadline() != null) {
                Date deadLineStamp = new Date(((Issue)element).getDeadlineTimestamp() + 86400000L);
                return !nowStamp.after(deadLineStamp);
            }
            return true;
        }
    }

    private class CategoryFilter
    extends ViewerFilter
    implements TreeSelectionFilter {
        private String categoryName;

        CategoryFilter(String categotyName) {
            this.categoryName = categotyName;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.categoryName.equals(((Issue)element).getCategory());
        }
    }

    private class IssueTypeFilter
    extends ViewerFilter
    implements TreeSelectionFilter {
        private String issueType;

        IssueTypeFilter(String issueType) {
            this.issueType = issueType;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.issueType.equals(((Issue)element).getType());
        }
    }

    private class ClearFilter
    extends ViewerFilter
    implements TreeSelectionFilter {
        ClearFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return false;
        }
    }

    private static interface TreeSelectionFilter {
    }
}

