/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.msglist;

import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.msglist.MessageFilter;
import org.eclipse.jface.dialogs.IDialogSettings;

public class MessageFilterManager {
    private static IDialogSettings setting = BtsPlugin.getInstance().getDialogSettings();
    public static final String SECTION_NAME = "MessageFilter";
    public static final String KEY_SYSTEM = "SYSTEM";
    public static final String KEY_USER = "USER";
    public static final String KEY_MESSAGECOMBO = "MESSAGECOMBO";
    public static final String KEY_MESSAGE = "MESSAGE";
    public static final String KEY_FROM = "FROM";
    public static final String KEY_TO = "TO";
    public static final String KEY_SENDER = "SENDER";

    public static void save(MessageFilter config) {
        IDialogSettings section = setting.addNewSection(SECTION_NAME);
        MessageFilterManager.setMessageFilter(section, config);
        setting.addSection(section);
    }

    public static void modify(MessageFilter oldConfig, MessageFilter newConfig) {
        IDialogSettings section = setting.getSection(SECTION_NAME);
        MessageFilterManager.setMessageFilter(section, newConfig);
    }

    public static void setMessageFilter(IDialogSettings section, MessageFilter config) {
        section.put(KEY_SYSTEM, config.isMsgSystemChk());
        section.put(KEY_USER, config.isMsgUserChk());
        section.put(KEY_MESSAGECOMBO, config.getMessageCmb());
        section.put(KEY_MESSAGE, config.getMessage());
        section.put(KEY_FROM, config.getFrmDate());
        section.put(KEY_TO, config.getToDate());
        section.put(KEY_SENDER, config.getSenderChk());
    }

    public static MessageFilter getMessageFilter() {
        IDialogSettings section = setting.getSection(SECTION_NAME);
        MessageFilter config = new MessageFilter();
        config.setMsgSystemChk(section.getBoolean(KEY_SYSTEM));
        config.setMsgUserChk(section.getBoolean(KEY_USER));
        config.setMessageCmb(section.get(KEY_MESSAGECOMBO));
        config.setMessage(section.get(KEY_MESSAGE));
        config.setFrmDate(section.get(KEY_FROM));
        config.setToDate(section.get(KEY_TO));
        config.setSenderChk(section.get(KEY_SENDER));
        return config;
    }
}

