/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class BtsTreeNode
implements Comparable {
    protected String textName = "";
    protected Image image = null;
    protected BtsTreeNode parent = null;
    protected List children = new ArrayList();

    public BtsTreeNode() {
    }

    public BtsTreeNode(BtsTreeNode parent, String textName, Image image) {
        this.parent = parent;
        this.textName = textName;
        this.image = image;
    }

    public BtsTreeNode getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public void addChild(BtsTreeNode treeNode) {
        if (this.children.contains(treeNode)) {
            this.children.remove(treeNode);
        }
        this.children.add(treeNode);
    }

    public void updateChild(BtsTreeNode treeNode) {
        if (this.children.contains(treeNode)) {
            this.children.remove(treeNode);
        }
        this.children.add(treeNode);
    }

    public void removeChild(BtsTreeNode node) {
        this.children.remove(node);
    }

    public boolean contains(BtsTreeNode node) {
        return this.children.contains(node);
    }

    public List getChildren() {
        return this.children;
    }

    public BtsTreeNode getChild(String key) {
        int idx = 0;
        while (idx < this.children.size()) {
            BtsTreeNode child = (BtsTreeNode)this.children.get(idx);
            if (child.getNodeKey().equals(key)) {
                return child;
            }
            ++idx;
        }
        return null;
    }

    public String getTextName() {
        return this.textName;
    }

    public void setTextName(String textName) {
        this.textName = textName;
    }

    public Image getImage() {
        return this.image;
    }

    public String getNodeKey() {
        return this.textName;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        BtsTreeNode that = (BtsTreeNode)obj;
        String thisKey = this.getTextName();
        String thatKey = that.getTextName();
        return thisKey.compareTo(thatKey);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }
}

