/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.util;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.data.IssueStatus;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BtsMailSender
implements Runnable {
    private Issue issue;
    private ProjectConfig projectConfig;

    public void run() {
        try {
            this.projectConfig = CurrentProject.getInsance().getProjectConfig();
            String smtp = this.projectConfig.getSmtp();
            String from = this.projectConfig.getSender();
            String to = this.projectConfig.getRecipient();
            String subject = this.projectConfig.getPrefix();
            String body = this.createBody();
            String currentDir = BtsPlugin.getInstance().getStateLocation() + "/";
            String attachmentFilePath = String.valueOf(currentDir) + "tmp.bts";
            FileOutputStream fileOutputStream = new FileOutputStream(attachmentFilePath);
            ObjectOutputStream objectOutput = new ObjectOutputStream(fileOutputStream);
            objectOutput.writeObject(this.issue);
            objectOutput.flush();
            String tmpFileName = String.valueOf(BTSUtility.formatDate(this.issue.getUpdateDate(), "yyyy.MM.dd.HH.mm.ss")) + ".bts";
            Properties props = new Properties();
            props.put("mail.smtp.host", smtp);
            Session session = Session.getInstance((Properties)props, null);
            subject = String.valueOf(subject) + Messages.getString("BtsMailSender.15") + this.issue.getDisplayIssueID() + "]" + this.issue.getTitle();
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.addFrom((Address[])InternetAddress.parse((String)from));
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            mimeMessage.setSubject(subject, "iso-2022-jp");
            mimeMessage.setSentDate(new Date());
            MimeMultipart content = new MimeMultipart();
            MimeBodyPart text = new MimeBodyPart();
            text.setText(body, "iso-2022-jp");
            content.addBodyPart((BodyPart)text);
            MimeBodyPart attachmentFile = new MimeBodyPart();
            attachmentFile.setDataHandler(new DataHandler((DataSource)new FileDataSource(attachmentFilePath)));
            attachmentFile.setFileName(tmpFileName);
            content.addBodyPart((BodyPart)attachmentFile);
            mimeMessage.setContent((Multipart)content);
            Transport.send((Message)mimeMessage);
        }
        catch (Exception exception) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)BtsPlugin.getInstance().getActiveEditor().getSite().getShell(), (String)Messages.getString("BtsMailSender.0"), (String)Messages.getString("BtsMailSender.1"));
                }
            });
        }
    }

    public String createBody() throws Exception {
        IssueHistory[] issueHistories = this.issue.getIssueHistories();
        StringBuffer body = new StringBuffer();
        body.append(Messages.getString("BtsMailSender.2"));
        body.append(Messages.getString("BtsMailSender.7"));
        body.append(Messages.getString("BtsMailSender.16"));
        body.append(Messages.getString("BtsMailSender.8"));
        body.append("==================================================\n");
        body.append(String.valueOf(Messages.getString("BtsMailSender.3")) + this.projectConfig.getProjectName() + "\n");
        body.append(String.valueOf(Messages.getString("BtsMailSender.4")) + CurrentProject.getInsance().getSSID() + "\n");
        body.append(String.valueOf(Messages.getString("BtsMailSender.5")) + issueHistories[0].getUpdateUser() + "\n");
        body.append(String.valueOf(Messages.getString("BtsMailSender.6")) + BTSUtility.formatDate(issueHistories[0].getUpdateDate(), "yyyy/MM/dd HH:mm:ss") + "\n");
        body.append("==================================================\n\n");
        body.append(Messages.getString("BtsMailSender.9"));
        body.append(String.valueOf(Messages.getString("BtsMailSender.17")) + this.issue.getVersion());
        body.append(String.valueOf(Messages.getString("BtsMailSender.18")) + this.issue.getDisplayIssueID());
        body.append(String.valueOf(Messages.getString("BtsMailSender.19")) + this.issue.getTitle());
        body.append(String.valueOf(Messages.getString("BtsMailSender.20")) + this.issue.getPriority());
        body.append(String.valueOf(Messages.getString("BtsMailSender.21")) + IssueStatus.getEnumFromValue(this.issue.getStatus()).getDescription());
        body.append(String.valueOf(Messages.getString("BtsMailSender.22")) + this.issue.getDescription());
        body.append(Messages.getString("BtsMailSender.23"));
        int i = 0;
        while (i < issueHistories.length) {
            if (this.issue.getUpdateDate().equals(issueHistories[i].getUpdateDate())) {
                String updateAttribute = issueHistories[i].getUpdateAttribute();
                if (IssueHistory.ISSUE_NON_UPDATE.equals(updateAttribute) || IssueHistory.ISSUE_INITIAL_REGIST.equals(updateAttribute) || IssueHistory.ISSUE_MOVE_GARBAGE.equals(updateAttribute)) {
                    body.append(String.valueOf(updateAttribute) + Messages.getString("BtsMailSender.10"));
                } else {
                    String afterDate;
                    String beforeDate = issueHistories[i].getUpdateBefore();
                    if (beforeDate == null) {
                        beforeDate = "";
                    }
                    if ((afterDate = issueHistories[i].getUpdateAfter()) == null) {
                        afterDate = "";
                    }
                    body.append(String.valueOf(Messages.getString("BtsMailSender.11")) + issueHistories[i].getUpdateAttribute() + Messages.getString("BtsMailSender.12"));
                    body.append(Messages.getString("BtsMailSender.13"));
                    body.append(String.valueOf(beforeDate) + "\n\n");
                    body.append(Messages.getString("BtsMailSender.14"));
                    body.append(String.valueOf(afterDate) + "\n\n");
                }
                body.append("--------------------------------------------------\n");
            }
            ++i;
        }
        return body.toString();
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
    }
}

