/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.util;

import java.util.ArrayList;
import java.util.Iterator;
import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.data.CommentHistory;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueAttribute;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.data.IssueStatus;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.CipherUtility;
import jp.valtech.bts.util.Messages;

public class IssueUtility {
    public static IssueHistory[] createIssueHistory(Issue oldIssue, Issue newIssue, CommentHistory newComment) {
        IssueHistory commentHistory;
        IssueHistory attachHistory;
        String date2;
        String date1;
        ArrayList<IssueHistory> historyList = new ArrayList<IssueHistory>();
        if (oldIssue.getVersion() == 0) {
            return IssueUtility.createInitialHistory(newIssue);
        }
        if (!IssueUtility.equals(oldIssue.getCategory(), newIssue.getCategory())) {
            historyList.add(new IssueHistory(newIssue, IssueAttribute.CATEGORY_VALUE, oldIssue.getCategory(), newIssue.getCategory()));
        }
        if (!IssueUtility.equals(oldIssue.getTitle(), newIssue.getTitle())) {
            historyList.add(new IssueHistory(newIssue, IssueAttribute.TITLE_VALUE, oldIssue.getTitle(), newIssue.getTitle()));
        }
        if (!IssueUtility.equals(oldIssue.getDescription(), newIssue.getDescription())) {
            historyList.add(new IssueHistory(newIssue, IssueAttribute.DESCRIPTION_VALUE, oldIssue.getDescription(), newIssue.getDescription()));
        }
        if (!IssueUtility.equals(oldIssue.getPriority(), newIssue.getPriority())) {
            historyList.add(new IssueHistory(newIssue, IssueAttribute.PRIORITY_VALUE, oldIssue.getPriority(), newIssue.getPriority()));
        }
        if (!IssueUtility.equals(oldIssue.getStatus(), newIssue.getStatus())) {
            historyList.add(new IssueHistory(newIssue, IssueAttribute.STATUS_VALUE, IssueStatus.getEnumFromValue(oldIssue.getStatus()).getDescription(), IssueStatus.getEnumFromValue(newIssue.getStatus()).getDescription()));
        }
        if (!IssueUtility.equals(oldIssue.getAssigned(), newIssue.getAssigned())) {
            historyList.add(new IssueHistory(newIssue, IssueAttribute.ASSIGNED_VALUE, oldIssue.getAssigned(), newIssue.getAssigned()));
        }
        if (!IssueUtility.equals(date1 = BTSUtility.formatDate(oldIssue.getDeadline(), "yyyy/MM/dd"), date2 = BTSUtility.formatDate(newIssue.getDeadline(), "yyyy/MM/dd"))) {
            historyList.add(new IssueHistory(newIssue, IssueAttribute.DEADLINE_VALUE, date1, date2));
        }
        if (!IssueUtility.equals(oldIssue.getSecretBug().toString(), newIssue.getSecretBug().toString())) {
            String oldSecretBug = Messages.getString("IssueUtility.3");
            if (oldIssue.getSecretBug().booleanValue()) {
                oldSecretBug = Messages.getString("IssueUtility.4");
            }
            String newSecretBug = Messages.getString("IssueUtility.3");
            if (newIssue.getSecretBug().booleanValue()) {
                newSecretBug = Messages.getString("IssueUtility.4");
            }
            historyList.add(new IssueHistory(newIssue, IssueAttribute.SECRETBUG_VALUE, oldSecretBug, newSecretBug));
        }
        if (!IssueUtility.equals(oldIssue.getSuspend().toString(), newIssue.getSuspend().toString())) {
            String oldSuspend = Messages.getString("IssueUtility.3");
            if (oldIssue.getSuspend().booleanValue()) {
                oldSuspend = Messages.getString("IssueUtility.4");
            }
            String newSuspend = Messages.getString("IssueUtility.3");
            if (newIssue.getSuspend().booleanValue()) {
                newSuspend = Messages.getString("IssueUtility.4");
            }
            historyList.add(new IssueHistory(newIssue, IssueAttribute.SUSPEND_VALUE, oldSuspend, newSuspend));
        }
        if ((attachHistory = IssueUtility.createAttachmentHistory(oldIssue, newIssue)) != null) {
            historyList.add(attachHistory);
        }
        if ((commentHistory = IssueUtility.createCommentHistory(newComment)) != null) {
            historyList.add(commentHistory);
        }
        if (historyList.size() == 0) {
            return IssueUtility.createNonUpdateHistory(newIssue);
        }
        return historyList.toArray(new IssueHistory[0]);
    }

    private static IssueHistory createAttachmentHistory(Issue oldIssue, Issue newIssue) {
        Attachment attachment;
        StringBuffer msg;
        ArrayList oldList = oldIssue.getAttachmentList();
        ArrayList newList = newIssue.getAttachmentList();
        if (!(oldList != null && oldList.size() != 0 || newList != null && newList.size() != 0)) {
            return null;
        }
        if (oldList != null && newList != null && oldList.size() == newList.size()) {
            ArrayList<String> newAttachFileNames = new ArrayList<String>();
            Iterator newIte = newList.iterator();
            while (newIte.hasNext()) {
                Attachment element = (Attachment)newIte.next();
                newAttachFileNames.add(element.getDisplayName());
            }
            ArrayList<String> oldAttachFileNames = new ArrayList<String>();
            Iterator oldIte = oldList.iterator();
            while (oldIte.hasNext()) {
                Attachment element = (Attachment)oldIte.next();
                oldAttachFileNames.add(element.getDisplayName());
            }
            boolean equals = true;
            if (!newAttachFileNames.containsAll(oldAttachFileNames)) {
                equals = false;
            }
            if (!oldAttachFileNames.containsAll(newAttachFileNames)) {
                equals = false;
            }
            if (equals) {
                return null;
            }
        }
        IssueHistory history = new IssueHistory(newIssue, IssueAttribute.ATTACHMENT_VALUE, Messages.getString("IssueUtility.0"), Messages.getString("IssueUtility.1"));
        if (oldList != null && oldList.size() != 0) {
            msg = new StringBuffer("");
            int i = 0;
            while (i < oldList.size()) {
                attachment = (Attachment)oldList.get(i);
                msg.append(attachment.getDisplayName()).append("\n");
                ++i;
            }
            history.setUpdateBefore(msg.toString());
        }
        if (newList != null && newList.size() != 0) {
            msg = new StringBuffer("");
            int i = 0;
            while (i < newList.size()) {
                attachment = (Attachment)newList.get(i);
                msg.append(attachment.getDisplayName()).append("\n");
                ++i;
            }
            history.setUpdateAfter(msg.toString());
        }
        return history;
    }

    public static IssueHistory createCommentHistory(CommentHistory newComment) {
        if (newComment == null) {
            return null;
        }
        IssueHistory history = new IssueHistory();
        history.setFingerPrint(newComment.getFingerPrint());
        history.setType("R");
        history.setUpdateAttribute(IssueAttribute.COMMENT_VALUE);
        history.setUpdateBefore("");
        history.setUpdateAfter(Messages.getString("IssueUtility.2"));
        history.setUpdateUser(newComment.getUpdateUser());
        history.setUpdateDate(newComment.getUpdateDate());
        return history;
    }

    public static IssueHistory[] createInitialHistory(Issue issue) {
        IssueHistory history = new IssueHistory();
        history.setFingerPrint(issue.getFingerPrint());
        history.setType("R");
        history.setUpdateAttribute(IssueHistory.ISSUE_INITIAL_REGIST);
        history.setUpdateBefore("");
        history.setUpdateAfter("");
        history.setUpdateUser(CurrentProject.getInsance().getProjectConfig().getUserName());
        history.setUpdateDate(issue.getUpdateDate());
        return new IssueHistory[]{history};
    }

    public static IssueHistory[] createNonUpdateHistory(Issue issue) {
        IssueHistory history = new IssueHistory();
        history.setFingerPrint(issue.getFingerPrint());
        history.setType("R");
        history.setUpdateAttribute(IssueHistory.ISSUE_NON_UPDATE);
        history.setUpdateBefore("");
        history.setUpdateAfter("");
        history.setUpdateUser(CurrentProject.getInsance().getProjectConfig().getUserName());
        history.setUpdateDate(issue.getUpdateDate());
        return new IssueHistory[]{history};
    }

    public static IssueHistory createGarbageHistory(Issue issue, String fromUser) {
        IssueHistory history = new IssueHistory();
        history.setFingerPrint(issue.getFingerPrint());
        history.setType("G");
        history.setUpdateAttribute(IssueHistory.ISSUE_MOVE_GARBAGE);
        history.setUpdateBefore("");
        history.setUpdateAfter("");
        history.setUpdateUser(fromUser);
        history.setUpdateDate(issue.getUpdateDate());
        return history;
    }

    public static String createFingerPrint(Issue issue) {
        StringBuffer buf = new StringBuffer();
        buf.append(issue.getType());
        buf.append(issue.getIssueID());
        buf.append(issue.getCategory());
        buf.append(issue.getTitle());
        buf.append(issue.getDescription());
        buf.append(issue.getPriority());
        buf.append(issue.getStatus());
        buf.append(issue.getDeadline());
        buf.append(issue.getAssigned());
        buf.append(issue.isSecretBug());
        buf.append(issue.isSuspend());
        buf.append(issue.getVersion());
        buf.append(issue.getCreateUser());
        buf.append(issue.getCreateDate());
        buf.append(System.currentTimeMillis());
        issue.setFingerPrint(CipherUtility.hash(buf.toString()));
        return issue.getFingerPrint();
    }

    public static Attachment[] getAttachmentDeleteList(ArrayList oldList, ArrayList newList) {
        if (oldList == null || oldList.size() == 0) {
            return null;
        }
        Attachment[] oldAttachments = oldList.toArray(new Attachment[0]);
        ArrayList<Attachment> deleteList = new ArrayList<Attachment>();
        int i = 0;
        while (i < oldAttachments.length) {
            if (!newList.contains(oldAttachments[i])) {
                deleteList.add(oldAttachments[i]);
            }
            ++i;
        }
        if (deleteList.size() == 0) {
            return null;
        }
        return deleteList.toArray(new Attachment[0]);
    }

    public static String[] getPriorities() {
        ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
        String priority = config.getPriority();
        if (priority == null || priority.equals("")) {
            return new String[]{""};
        }
        String[] priorities = priority.split("[|]");
        int i = 0;
        while (i < priorities.length) {
            priorities[i] = priorities[i].trim();
            ++i;
        }
        return priorities;
    }

    public static String[] getCategories() {
        ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
        String category = config.getCategory();
        if (category == null || category.equals("")) {
            return new String[]{""};
        }
        String[] categories = category.split("[|]");
        int i = 0;
        while (i < categories.length) {
            categories[i] = categories[i].trim();
            ++i;
        }
        return categories;
    }

    public static String[] getAssigned() {
        ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
        String assigned = config.getAssigned();
        if (assigned == null || assigned.equals("")) {
            return new String[]{""};
        }
        String[] allAssigned = assigned.split("[|]");
        int i = 0;
        while (i < allAssigned.length) {
            allAssigned[i] = allAssigned[i].trim();
            ++i;
        }
        return allAssigned;
    }

    private static boolean equals(String diff1, String diff2) {
        if (diff1 == null && diff2 == null) {
            return true;
        }
        if (diff1 == null && diff2 != null) {
            return false;
        }
        return diff1.equals(diff2);
    }
}

