/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.command.client;

import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.MulticastClientCommand;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

/**
 * <dl><dt><b>ネットワークから離脱ことを通知するためのコマンドです。</b></dt>
 * <dd>このコマンドを実行することで、同一のマルチキャストアドレスのネットワークから離脱することを通知します。
 * 離脱対象の参加者名は{@link jp.valtech.bts.data.NetworkConfig#setDisplayName(String)}で指定します。
 * </dd>
 * </dl>
 * 
 * @see			jp.valtech.bts.command.server.LeaveServer
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class Leave extends MulticastClientCommand implements Logging {

	/**
	 * 離脱コマンドインスタンスを生成します。
	 * 
	 * @param		config		ネットワーク情報
	 */
	public Leave( NetworkConfig myconfig ) {
		super( myconfig );
	}


	/**
	 * 離脱コマンドを実行します。
	 *
	 */
	public void execute() {
		Request request = new Request();
		request.setCommand( "leave" );
		request.setSSID( this.myconfig.getSSID() );
		try {
			send( request );
		} catch (Exception e) {
			BtsPlugin.getInstance().errorlog(e);
		}
	}

}
