/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.dao;

/**
 * DB関連での例外クラスです。
 * {@link java.lang.Exception}を親クラスに持ちます。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class BtsDBException  extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7550468441296196767L;

	/**
	 * 何もしません。
	 */
	public BtsDBException() {
    	super();
	}

    /**
     * {@link java.lang.Throwable}をわたします。
     * @param			cause					Throwable
     */
    public BtsDBException(Throwable cause) {
    	super(cause);
    }

    /**
     * メッセージ文字列を渡します。
     * @param			message
     */
    public BtsDBException(String message) {
    	super(message);
    }

    /**
     * {@link java.lang.Throwable}とメッセージを渡します。
     * @param			message
     * @param			cause				Throwable
     */
    public BtsDBException(String message, Throwable cause) {
    	super(message, cause);
    }
}
