/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import jp.valtech.bts.connection.DBConnection;
import jp.valtech.bts.data.CommentHistory;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

/**
 * <dl><dt><b>コメント履歴用のDAO</b></dt>
 * <dd>
 * </dd>
 * <dt><b>使い方</b></dt>
 * <dd>
 * </dd>
 * </dl>
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class CommentHistoryDAO extends DataBaseAccessor {

	/** テーブル作成SQL */
	private static final String CREATE_TABLE
			= "CREATE TABLE COMMENTHISTORY"
			+ " ( FINGERPRINT CHAR(40)"
			+ " , TYPE     	  CHAR(1)"
			+ " , DESCRIPTION LONGVARCHAR"
			+ " , UPDATEUSER  VARCHAR(30)"
			+ " , UPDATEDATE  TIMESTAMP"
			+ " ) ;";

	/** テーブル削除SQL */
	private static final String DROP_TABLE
			= "DROP TABLE COMMENTHISTORY CASCADE;";

	/** データ登録SQL */
	private static final String INSERT_SQL
			= "INSERT INTO COMMENTHISTORY"
			+ " ( FINGERPRINT"
			+ " , TYPE"
			+ " , DESCRIPTION"
			+ " , UPDATEUSER"
			+ " , UPDATEDATE"
			+ " )"
			+ " VALUES (?, ?, ?, ?, ?)";

	/** データ削除用SQL */
	private static final String DELETE_SQL
			= "DELETE FROM COMMENTHISTORY WHERE FINGERPRINT=? AND TYPE=?";

	/** ごみ箱に移動するSQL */
	private static final String UPDATE_GARBAGE	
			= "UPDATE COMMENTHISTORY SET TYPE='G' WHERE FINGERPRINT=? AND TYPE='R'"; 

	/** データを全件取得するSQL */
	private static final String SELECT_ALL
			= "SELECT"
			+ "   FINGERPRINT"
			+ " , TYPE"
			+ " , DESCRIPTION"
			+ " , UPDATEUSER"
			+ " , UPDATEDATE"
			+ " FROM COMMENTHISTORY";

	/** フィンガープリントに対応するデータを取得するSQL */
	private static final String SELECT_BY_FINGERPRINT	
			= SELECT_ALL + " WHERE FINGERPRINT=? AND TYPE=? ORDER BY UPDATEDATE DESC";

	/**
	 * <DL><DT><B>コンストラクタ</B>
	 *  <DD></DD>
	 * </DL>
	 * @param connection
	 */
	public CommentHistoryDAO( DBConnection connection ) {
		super( connection );
	}

	/**
	 * テーブルを生成します。
	 * 
	 * @throws		BtsDBException
	 */
	public void createTable() throws BtsDBException {
		try {
			// テーブル生成用SQL実行
			new QueryRunner().update( this.con, CREATE_TABLE );
			
		} catch (Exception e) {
			throw new BtsDBException(e);
		}
	}

	
	/**
	 * テーブルを削除します。
	 * 
	 * @throws		BtsDBException
	 */
	public void dropTable() throws BtsDBException {
		try {
			// テーブル削除用SQL実行
			new QueryRunner().update( this.con, DROP_TABLE );	
		} catch (Exception e) {
			throw new BtsDBException(e);
		}
	}

	/**
	 * <DL><DT><B>データを登録します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param commentHistory
	 * @throws BtsDBException
	 */
	public void addComment( CommentHistory commentHistory ) throws BtsDBException {
		try {
			List param = new ArrayList();
			param.add( commentHistory.getFingerPrint() );
			param.add( commentHistory.getType() );
			param.add( commentHistory.getDescription() );
			param.add( commentHistory.getUpdateUser() );
			if( commentHistory.getUpdateDate() != null ){
				param.add( new Timestamp( commentHistory.getUpdateDateTimestamp() ) );
			}else{
				param.add( null );
			}

			new QueryRunner().update( this.con, INSERT_SQL, param.toArray() );	
		} catch (Exception e) {
			throw new BtsDBException(e);
		}
	}


	/**
	 * <DL><DT><B>データを削除します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param commentHistory
	 * @throws BtsDBException
	 */
	public void deleteByFingerPrint( String fingerPrint, String type ) throws BtsDBException {
		try {
			List param = new ArrayList();
			param.add( fingerPrint );
			param.add( type );
			
			new QueryRunner().update( this.con, DELETE_SQL, param.toArray() );	
		} catch (Exception e) {
			throw new BtsDBException(e);
		}
	}

	
	/**
	 * <DL><DT><B>指定された指紋とタイプに属するデータを取得します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param 		fingerPrint		指紋
	 * @param		type			課題票タイプ
	 * @return		指定された指紋と課題票タイプに属するコメント全件
	 * @throws 	BtsDBException
	 */
	public CommentHistory[] getByFingerPrint( String fingerPrint, String type ) throws BtsDBException{
		CommentHistory[] commentHistories = new CommentHistory[]{};
		List param = new ArrayList();
		param.add( fingerPrint );
		param.add( type );
		
		try {
			
			ResultSetHandler rsh = new BeanListHandler(CommentHistory.class);
			
			List result = (List)new QueryRunner().query( this.con, SELECT_BY_FINGERPRINT, param.toArray(), rsh );
			
			commentHistories = (CommentHistory[])result.toArray( commentHistories );
			
			
		} catch (Exception e) {
			throw new BtsDBException(e);
		}
		
		return commentHistories;
	}

	/**
	 * <DL><DT><B>指定の課題票をごみ箱に移動します。</B></DT>
	 *  <DD></DD>
	 * </DL>
	 * @param		fingerPrint			削除対象の課題票のFingerPrint
	 * @throws 		BtsDBException
	 */
	public void changeGarbageVersion(String fingerPrint) throws BtsDBException{
		try {
			List param = new ArrayList();
			param.add(fingerPrint);

			new QueryRunner().update( this.con, UPDATE_GARBAGE, param.toArray() );	
		} catch (Exception e) {
			throw new BtsDBException(e);
		}
	}
}
