/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.beans.XMLEncoder;

/**
 * {@link XMLEncoder}を利用してバグ累計情報をXMLに出力するためのJavaBeansクラスです。
 * {@link XMLEncoder}を利用するにはデフォルトコンストラクタが存在しなければなりません。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class OutputBugChart {

	/** 日付 */
	private String date;
	
	/** 発生バグ累計 */
	private String openedBug;
	
	/** 解決バグ累計 */
	private String closedBug;
	
	/** 残存バグ累計 */
	private String remainBug;
	
	/** ヘッダ文字列 */
	private String header;
	
	/** フッタ文字列 */
	private String footer;
	
	/** レポート出力日時(yyyy/MM/dd HH:mm) */
	private String nowDate;
	
	/** 出力単位 */
	private String unit;
	
	
	/**
	 * デフォルトコンストラクタです。
	 */
	public OutputBugChart() {
	}


	/**
	 * @return closedBug を戻します。
	 */
	public String getClosedBug() {
		return closedBug;
	}


	/**
	 * @param closedBug 設定する closedBug。
	 */
	public void setClosedBug(String closedBug) {
		this.closedBug = closedBug;
	}


	/**
	 * @return date を戻します。
	 */
	public String getDate() {
		return date;
	}


	/**
	 * @param date 設定する date。
	 */
	public void setDate(String date) {
		this.date = date;
	}


	/**
	 * @return footer を戻します。
	 */
	public String getFooter() {
		return footer;
	}


	/**
	 * @param footer 設定する footer。
	 */
	public void setFooter(String footer) {
		this.footer = footer;
	}


	/**
	 * @return header を戻します。
	 */
	public String getHeader() {
		return header;
	}


	/**
	 * @param header 設定する header。
	 */
	public void setHeader(String header) {
		this.header = header;
	}


	/**
	 * @return nowDate を戻します。
	 */
	public String getNowDate() {
		return nowDate;
	}


	/**
	 * @param nowDate 設定する nowDate。
	 */
	public void setNowDate(String nowDate) {
		this.nowDate = nowDate;
	}


	/**
	 * @return openedBug を戻します。
	 */
	public String getOpenedBug() {
		return openedBug;
	}


	/**
	 * @param openedBug 設定する openedBug。
	 */
	public void setOpenedBug(String openedBug) {
		this.openedBug = openedBug;
	}


	/**
	 * @return remainBug を戻します。
	 */
	public String getRemainBug() {
		return remainBug;
	}


	/**
	 * @param remainBug 設定する remainBug。
	 */
	public void setRemainBug(String remainBug) {
		this.remainBug = remainBug;
	}


	/**
	 * @return unit を戻します。
	 */
	public String getUnit() {
		return unit;
	}


	/**
	 * @param unit 設定する unit。
	 */
	public void setUnit(String unit) {
		this.unit = unit;
	}
	
	
	
	
}
