/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.editor.IssueDetailsExportDialog;
import jp.valtech.bts.ui.editor.IssueMultiPageEditor;
import jp.valtech.bts.ui.editor.OverviewPart;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * {@link OpenDetailsExportDlgAction 課題票詳細出力ダイアログ}を開くアクションです。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class OpenDetailsExportDlgAction extends Action {
	
	/** 活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("export.gif"); 
	/** 非活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("export_disable.gif"); 

	/** このアクションの呼び出しもとのビューオブジェクト */
	private OverviewPart overviewPart;
	
	/** マルチページエディタの親 */
	private IssueMultiPageEditor parentEditor;

	
	/**
	 * 呼び出し元のビューインスタンスを設定します。
	 * 
	 * @param		navigatorView			 呼び出し元のビューインスタンス
	 */
	public OpenDetailsExportDlgAction(OverviewPart overviewPart, IssueMultiPageEditor parentEditor) {
		super();
		this.overviewPart = overviewPart;
		this.parentEditor = parentEditor;
		setText(Messages.getString("OpenDetailsExportDlgAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("OpenDetailsExportDlgAction.1"));  //$NON-NLS-1$

		setImageDescriptor(THIS_IMAGE);
		setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
	}


	/**
	 * {@link IssueDetailsExportDialog}を開きます。
	 */
	public void run() {

		IssueDetailsExportDialog issueDetailsExportDialog = new IssueDetailsExportDialog(overviewPart.getSite().getShell(), overviewPart.attachViewer, parentEditor);
		issueDetailsExportDialog.open();

	}

}
