/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.msglist.MessageFilterDialog;
import jp.valtech.bts.ui.msglist.MessageListView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * {@link MessageFilterDialog メッセージフィルターグラフダイアログ}を開くアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class OpenMsgFilterDlgAction extends Action {

	/** 活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("filter.gif"); 
	/** 非活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("filter_disable.gif"); 

	/** このアクションの呼び出しもとのビューオブジェクト */
	private MessageListView view;

	/**
	 * 呼び出し元のビューインスタンスを設定します。
	 * 
	 * @param		view			 呼び出し元のビューインスタンス
	 */
	public OpenMsgFilterDlgAction(MessageListView view) {
		super();
		this.view = view;
		setText(Messages.getString("OpenMsgFilterDlgAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("OpenMsgFilterDlgAction.1"));  //$NON-NLS-1$

		setImageDescriptor(THIS_IMAGE);
		setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
	}

	
	/**
	 * {@link MessageFilterDialog メッセージフィルターグラフダイアログ}を開きます。
	 */
	public void run() {
		MessageFilterDialog dialog = new MessageFilterDialog(view);
		dialog.open();
	}

}
