/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.issuelist;

import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.jface.dialogs.IDialogSettings;

/**
 * XMLに課題票フィルタ情報を登録します。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class IssueFilterManager {

	/** ダイアログセッティング生成 */
	private static IDialogSettings setting = BtsPlugin.getInstance().getDialogSettings();
	
	/** 課題票フィルターセクション名 */
	public static final String SECTION_NAME = "IssueFilter";
	
	/** 課題票ID */
	public static final String KEY_ISSUEID = "ISSUEID";
	
	/** From起票日 */
	public static final String KEY_FROM = "FROM";
	
	/** To起票日 */
	public static final String KEY_TO = "TO";
	
	/** タイトルコンボ */
	public static final String KEY_TITLECOMBO = "TITLECOMBO";
	
	/** タイトル */
	public static final String KEY_TITLE = "TITLE";
	
	/** 詳細コンボ */
	public static final String KEY_DESCCOMBO = "DESCCOMBO";
	
	/** 詳細 */
	public static final String KEY_DESC = "DESC";
	
	/** チェックが付いていない担当者 */
	public static final String KEY_ASSIGNED = "ASSIGNED";
	
	/** チェックが付いていない優先度 */
	public static final String KEY_PRIORITY = "PRIORITY";
	
	/** ステータス：起票 */
	public static final String KEY_STOPEN = "STOPEN";
	
	/** ステータス：担当者割り当て済み */
	public static final String KEY_STASSIGNED = "STASSIGNED";
	
	/** ステータス：対応済み */
	public static final String KEY_STRESOLVED = "STRESOLVED";
	
	/** ステータス：確認済み */
	public static final String KEY_STVERIFIED = "STVERIFIED";
	
	/** ステータス：完了 */
	public static final String KEY_STCLOSED = "STCLOSED";
	
	/** 内緒のバグ */
	public static final String KEY_SECRET = "SECRET";
	
	/** 保留中 */
	public static final String KEY_RESERVE = "RESERVE";
	
	/** 完了期限切れ */
	public static final String KEY_DEADLINE = "DEADLINE";
	
	
	
	/**
	 * 課題票フィルタ情報を保存します。
	 * @param		config		課題票フィルタ情報
	 */
	public static void save(IssueFilter config){
		// 新しいセクション作成
		IDialogSettings section = setting.addNewSection(SECTION_NAME);
		// セクションに課題票フィルタ情報をセット
		setIssueFilter(section, config);
		// XMLにセクションを登録
		setting.addSection(section);
	}
	
	/**
	 * 課題票フィルタ情報を更新します。
	 * @param		oldConfig		旧課題票フィルタ情報
	 * @param		newConfig		新しい課題票フィルタ情報
	 */
	public static void modify(IssueFilter oldConfig, IssueFilter newConfig) {
		// 更新する課題票フィルタ情報のセクション取得
		IDialogSettings section = setting.getSection(SECTION_NAME);
		// 新しいメッセージフィルタ情報を上書き更新
		setIssueFilter(section, newConfig);
	}
	
	
	/**
	 * セクションに課題票フィルタ情報を登録します。
	 */
	public static void setIssueFilter(IDialogSettings section, IssueFilter config) {
		// セクションに登録
		section.put(KEY_ISSUEID, config.getIssueID());
		section.put(KEY_FROM, config.getFrmDate());
		section.put(KEY_TO, config.getToDate());
		section.put(KEY_TITLECOMBO, config.getTitleCmb());
		section.put(KEY_TITLE, config.getTitle());
		section.put(KEY_DESCCOMBO, config.getDescCmb());
		section.put(KEY_DESC, config.getDesc());
		section.put(KEY_ASSIGNED, config.getAssignedChk());
		section.put(KEY_PRIORITY, config.getPriorityChk());
		section.put(KEY_STOPEN, config.isStOpenChk());
		section.put(KEY_STASSIGNED, config.isStAssignedChk());
		section.put(KEY_STRESOLVED, config.isStResolvedChk());
		section.put(KEY_STVERIFIED, config.isStVerifiedChk());
		section.put(KEY_STCLOSED, config.isStClosedChk());
		section.put(KEY_SECRET, config.isSecretChk());
		section.put(KEY_RESERVE, config.isReserveChk());
		section.put(KEY_DEADLINE, config.isDeadLineChk());
		
		
	}



	/**
	 * IssueFilterに登録済みフィルタ情報をセットします。
	 * @return
	 */
	public static IssueFilter getIssueFilter() {
		// セクション取得
		IDialogSettings section = setting.getSection(SECTION_NAME);
		
		// XMLのフィルタ情報をIssueFilterに登録
		IssueFilter config = new IssueFilter();

		
		config.setIssueID(section.get(KEY_ISSUEID));
		config.setFrmDate(section.get(KEY_FROM));
		config.setToDate(section.get(KEY_TO));
		config.setTitleCmb(section.get(KEY_TITLECOMBO));
		config.setTitle(section.get(KEY_TITLE));
		config.setDescCmb(section.get(KEY_DESCCOMBO));
		config.setDesc(section.get(KEY_DESC));
		config.setAssignedChk(section.get(KEY_ASSIGNED));
		config.setPriorityChk(section.get(KEY_PRIORITY));
		config.setStOpenChk(section.getBoolean(KEY_STOPEN));
		config.setStAssignedChk(section.getBoolean(KEY_STASSIGNED));
		config.setStResolvedChk(section.getBoolean(KEY_STRESOLVED));
		config.setStVerifiedChk(section.getBoolean(KEY_STVERIFIED));
		config.setStClosedChk(section.getBoolean(KEY_STCLOSED));
		config.setSecretChk(section.getBoolean(KEY_SECRET));
		config.setReserveChk(section.getBoolean(KEY_RESERVE));
		config.setDeadLineChk(section.getBoolean(KEY_DEADLINE));
		
		
		return config;
		
	}
	
}
