/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.preference;

import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * 共通設定画面（課題票）を生成します。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class IssuePreferencePage extends FieldEditorPreferencePage implements
		IWorkbenchPreferencePage {

	/** 課題票総容量キー */
	public static final String P_MAX_APPEND_CAPACITY = "PreferencePage.MaxAppendCapacity";
	/** デフォルト容量 */
	public static final String DEFAULT_CAPACITY = "";
	/** テキストフィールド幅 */
	private static final int TEXT_FIELD_WIDTH = 5;
	
	/**
	 * 初期設定
	 */
	public IssuePreferencePage() {
		super(GRID);
		super.setPreferenceStore(BtsPlugin.getInstance().getPreferenceStore());
		initializeDefaults();
	}
	
	/**
	 * デフォルトの設定を行います。
	 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setDefault(P_MAX_APPEND_CAPACITY, DEFAULT_CAPACITY);
	}

	/* (非 Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
	 */
	protected void createFieldEditors() {
		Composite composite = new Composite(getFieldEditorParent(), SWT.NONE);
		// フィールドエディタ生成
		StringFieldEditor stringFieldEditor = new StringFieldEditor(P_MAX_APPEND_CAPACITY, Messages.getString("IssuePreferencePage.0"), composite); //$NON-NLS-1$
		// テキスト取得
		Text text = stringFieldEditor.getTextControl(composite);
		// グリッドデータ取得
		GridData gridData = (GridData) text.getLayoutData();
		// テキストフィールドの固定幅を設定
		gridData.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
		// グリッドデータ設定
		text.setLayoutData(gridData);
		// フィールドエディタ設定
		addField(stringFieldEditor);
		// ラベル設定
		Label label = new Label(getFieldEditorParent(), SWT.NONE);
		label.setText("KB");
		
		// テキストを非活性
		text.setEnabled(false);
		
	}

	/* (非 Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}

}
