/*
 * Decompiled with CFR 0.152.
 */
package primitive;

import io.fileload;
import java.io.FileNotFoundException;
import java.io.IOException;
import primitive.SnpData;
import primitive.Snp_DataReader;
import primitive.pearson;

public class primitive {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        String[] data1 = fileload.loadLine0(args[0]);
        SnpData[] snpData1 = new SnpData[data1.length];
        int j = 0;
        while (j < data1.length) {
            snpData1[j] = Snp_DataReader.DataReaderSetData(data1[j], 2);
            ++j;
        }
        String[] data2 = fileload.loadLine0(args[1]);
        SnpData[] snpData2 = new SnpData[data2.length];
        int j2 = 0;
        while (j2 < data2.length) {
            snpData2[j2] = Snp_DataReader.DataReaderSetData(data2[j2], 2);
            ++j2;
        }
        SnpData[][] data = Snp_DataReader.DataReaderMakeParallelData(snpData1, snpData2);
        double Sobs = 0.0;
        int top = 0;
        int j3 = 0;
        while (j3 < data[0].length) {
            int[] populationType = Snp_DataReader.populationType(data[0][j3], data[1][j3]);
            int[][] Tobs = Snp_DataReader.DataReaderMakeTable(data[0][j3], data[1][j3], populationType);
            double S = pearson.S(Tobs);
            if (S != Double.NaN && S > Sobs) {
                Sobs = S;
                top = j3;
            }
            ++j3;
        }
        System.out.print("Observed:");
        System.out.print(data[0][top].rsNumber);
        System.out.print("\t");
        System.out.print(Sobs);
        System.out.println();
        int repeat2 = 10000;
        int count = 0;
        System.out.println("Permutation");
        int i = 0;
        while (i < repeat2) {
            double Sperm = 0.0;
            int a = data[0][0].SNPdata.length;
            int b = data[1][0].SNPdata.length;
            int n = a + b;
            int[] omega = primitive.omega(n);
            int[] di = primitive.di(n, a, omega);
            int j4 = 0;
            while (j4 < data[0].length) {
                int[][] Tperm = Snp_DataReader.DataReaderMakeTable(data[0][j4], data[1][j4], di);
                double S = pearson.S(Tperm);
                if (S != Double.NaN && S > Sperm) {
                    Sperm = S;
                    top = j4;
                }
                ++j4;
            }
            if (Sperm > Sobs) {
                ++count;
            }
            ++i;
        }
        System.out.println((double)count / (double)repeat2);
    }

    public static int[] omega(int len) {
        int[] result = new int[len];
        int[] flag = new int[len];
        int h = 0;
        while (h < len) {
            int x = 1;
            do {
                result[h] = x = (int)(Math.random() * (double)len);
            } while (flag[x] > 0);
            int n = x;
            flag[n] = flag[n] + 1;
            ++h;
        }
        return result;
    }

    public static int[] di(int n, int a, int[] omega) {
        int[] result = new int[n];
        int h = 0;
        while (h < a) {
            int n2 = omega[h];
            result[n2] = result[n2] + 1;
            ++h;
        }
        return result;
    }

    public static void showVector(int[] data) {
        int h = 0;
        while (h < data.length) {
            System.out.print(data[h]);
            System.out.print("\t");
            ++h;
        }
        System.out.println();
    }

    public static double PrimitiveMain(SnpData[][] data, double Sobs, int generation, int burnin) {
        int repeat2 = generation;
        int count = 0;
        int top = 0;
        int i = 0;
        while (i < repeat2) {
            double Sperm = 0.0;
            int a = data[0][0].SNPdata.length;
            int b = data[1][0].SNPdata.length;
            int n = a + b;
            int[] omega = primitive.omega(n);
            int[] di = primitive.di(n, a, omega);
            int j = 0;
            while (j < data[0].length) {
                int[][] Tperm = Snp_DataReader.DataReaderMakeTable(data[0][j], data[1][j], di);
                double S = pearson.S(Tperm);
                if (S != Double.NaN && S > Sperm) {
                    Sperm = S;
                    top = j;
                }
                ++j;
            }
            if (Sperm >= Sobs) {
                ++count;
            }
            ++i;
        }
        return (double)count / (double)repeat2;
    }
}

