#include <math.h>

double ChiTest_threshold = 6.634896712; // d.f.=1, p=1%

double ChiTestChiSquare1(int A, int B, int C, int D){
  double a = A;
  double b = B;
  double c = C;
  double d = D;
  double N = a+b+c+d;
  double chi2 =  ( (a*d-b*c)*(a*d-b*c)* N ) 
              / ( (a+c)*(b+d)*(a+b)*(c+d)  );
  return chi2;
}
int ChiTestUpperLimit(int sampleSize, double frequency,int haba ){
  double x = sqrt(ChiTest_threshold*sampleSize*frequency);
  int n= (int) (sampleSize*frequency+x)+haba;
  if(n<sampleSize) return n;
  return sampleSize;
}

int ChiTestLowerLimit(int sampleSize, double frequency,int haba ){
  double x = sqrt(ChiTest_threshold*sampleSize*frequency);
  int n= (int) (sampleSize*frequency-x)-haba;
  if(0<=n) return n;
  return 0;
}
/**/

int ChiTestChiTest(int sampleSize, int patient, int control){
  double chi2=ChiTestChiSquare1(patient,sampleSize-patient, control, sampleSize-control);
  if (chi2 != chi2) return 0; //check nan
  if (chi2>ChiTest_threshold) {
    return 1;
  }
  return 0;
}  

int ChiTestChiTest2(int A, int B, int C, int D){
  double chi2=ChiTestChiSquare1(A,B,C,D);
  if (chi2>ChiTest_threshold) {
    return 1;
  }
  return 0;
}  

int ChiTestIsSigniDiff(int** data, int sampleSize, int data_length){
  int i;
  for(i=0;i<data_length;i++){
    if( ChiTestChiTest(sampleSize,data[0][i],data[1][i])==1 ) return 1;
//      if( isSigniDiff(data[0][i],data[1][i]) ) return true;
  }
  return 0;
}

/*
bool ChiTestIsSigniDiff(int i, int j){
  return !(ChiTestSigniDiff[i][j]);
}
*/

int ChiTestSignificant3(int sampleSize, int** data, int data_length, double* frequency){
  int result=0; 
  int i;
  for(i=0;i<data_length;i++){
    if(ChiTestChiTest(sampleSize,data[0][i],data[1][i])==1) return 1;
  }/**/
  return result;
}

int ChiTestSignificant2(int sampleSize, int obs,  double frequency ){
  double exp = sampleSize*frequency;
  double chi2 = ( (double) (obs-exp)) *( (double) (obs-exp)) / ( (double) exp );
  if (chi2>ChiTest_threshold) {
    //System.out.println("signi\t" + chi2);
    return 1;
  }
  return 0;
}  

int ChiTestSignificant(int sampleSize, int* obs, int obs_num, double* frequency ){
  int result=0; // if not significant, result=1;
  int i;
  for(i=0;i<obs_num;i++){
    if(ChiTestSignificant2(sampleSize,obs[i],frequency[i])==1) result=1;
  }
  return result;
}

