#include <math.h>

#include "snp_MultiNomial.h"

double FactorialGetLogFactorial(int n);

static double MultiNomialLogMultinomialP(int size, int* X, int X_num, double* h){
  int i;
  int L;
  double logResult;

  L = X_num; // L is the number of haplotypes
  // Sum of X[i] (i=0...L) is the number of samples
  logResult=FactorialGetLogFactorial(size);
  for(i=0;i<L;i++){
    logResult -= FactorialGetLogFactorial(X[i]);
    logResult += log(h[i])*X[i];
  }
      return logResult;
}

double MultiNomialMultinomialP(int size, int* X, int X_num, double* h){
      return exp(MultiNomialLogMultinomialP(size,X,X_num,h));
}

double MultiNomialMultinomialP2(int size, int** X, int X_length, double* h){
  double logCaseP = MultiNomialLogMultinomialP(size,X[0],X_length, h);
  double logControlP = MultiNomialLogMultinomialP(size,X[1],X_length, h);
      return exp(logControlP+logCaseP);
}  

