package distance;

public class Kim2_dis extends JC_dis{ 
	
    public double P, Q, S, T,d1,d2; //S and T are for GP, d1 and d2 are for TATA 
    double SP, SQ, TQ;     //  dP/dS, dP/dt, dQ/dt,
    double d1P, d1Q,  d2Q;  //  dd1/dP, dd1/dQ, dd2/dQ,
    public static final double C = 0.75;
    public static final int limit = 100;  //limit for biased/unbiased
    public static double[][] UBS;
    public static double[] UBT;
    public static double[][][] UBS2;
    public static double[][] UBT2;
 
    void set_PQ3(int ks,int kv,int n) { //dec 26 
        P = ((double)ks)/((double)len);
        Q = ((double)kv)/((double)len);
        int k0 = kv+ks;
        d1 = unbiased_S2(ks,kv,n);  // Tajima1993(19)=Kimura1980(7)/2=2(a+b)t
        d2 = unbiased_T2(kv,n);     // Tajima1993(20)=Kimura1980(8)/4=2bt

        d1P = 1/(1-2*P-Q);      //dd1/dP
        d1Q = 0.5/(1-2*P-Q);    //dd1/dQ
        d2Q = 0.5/(1-2*Q);       //dd2/dQ

        S = d1-d2;   // 2at
        T = d2;      // 2bt


        SP = 1/(1-2*P-Q);                 //dS/dP
        SQ = 0.5/(1-2*P-Q)-0.5/(1-2*Q);   //dS/dQ
        TQ = 0.5/(1-2*Q);                 //dT/dQ

        k = S+2*T;
        p = ( (double) (kv+ks) ) / ( (double) (len) );

        set = true;
    }
 
    void set_PQ4(int ks,int kv,int n) { //dec 26 
        P = ((double)ks)/((double)n);
        Q = ((double)kv)/((double)n);
        int k0 = kv+ks;
        if(n<=limit){
            d1 = unbiased_S2(ks,kv,n);  // Tajima1993(19)=Kimura1980(7)/2=2(a+b)t
            d2 = unbiased_T2(kv,n);     // Tajima1993(20)=Kimura1980(8)/4=2bt
        }else{ // if long enough, small bias.
            d1 = biased_S2(ks,kv,n);  // Tajima1993(19)=Kimura1980(7)/2=2(a+b)t
            d2 = biased_T2(kv,n);     // Tajima1993(20)=Kimura1980(8)/4=2bt
        }
        d1P = 1/(1-2*P-Q);      //dd1/dP
        d1Q = 0.5/(1-2*P-Q);    //dd1/dQ
        d2Q = 0.5/(1-2*Q);       //dd2/dQ

        S = d1-d2;   // 2at
        T = d2;      // 2bt


        SP = 1/(1-2*P-Q);                 //dS/dP
        SQ = 0.5/(1-2*P-Q)-0.5/(1-2*Q);   //dS/dQ
        TQ = 0.5/(1-2*Q);                 //dT/dQ

        k = S+2*T;
        p = ( (double) (kv+ks) ) / ( (double) (n) );

        set = true;
    }
 
    double unbiased_T2(int kv, int seq_len) { 
        UBT2 = TableMan.init_2D(seq_len,kv,UBT2);
        if (UBT2[seq_len][kv]<0){ // if not initialized, calculate.
            double total=0;
            for(int i=1;i<=kv;i++){
                total += Math.exp( (i-2)*Math.log(2) +fact.lnP(kv,i) -fact.lnP(seq_len,i) ) /i;
            }
            if( Double.isNaN(total)||Double.isInfinite(total) ){ //inapplicable
                System.err.println("out of range:T");
                double q = ((double) kv) / ((double) len);
                UBT2[seq_len][kv] = - Math.log(1-2*q)/4;
            }else{
                UBT2[seq_len][kv] = total;
            }
        }
        return UBT2[seq_len][kv];
    }

 
    double biased_T2(int kv, int seq_len) { 
        UBT2 = TableMan.init_2D(seq_len,kv,UBT2);
        if (UBT2[seq_len][kv]<0){ // if not initialized, calculate.
//            System.err.println("biased T");
            double q = ((double) kv) / ((double) len);
            UBT2[seq_len][kv] = - Math.log(1-2*q)/4;
        }
        return UBT2[seq_len][kv];
    }

 
    double unbiased_S2(int ks, int kv, int seq_len)  { 
        // x...ks y..kv

        UBS2 = TableMan.init_3D(seq_len, kv, ks,UBS2);  // note
        // not initialized
        if (UBS2[seq_len][kv][ks]<0){ // if not initialized
            double total=0;
            int k0 = ks+kv;
            for(int i=1;i<=k0;i++){
                int min = i-kv;
                if(min<0) min=0;
                int max=i;
                if(max>ks) max=ks;

                double tmp=0;
                for(int j=min;j<=max;j++){
                     boolean flag = true;
                     tmp +=
                        Math.exp( fact.lnC(i,j) + (j-1)*Math.log(2)
                          + fact.lnP(ks,j) + fact.lnP(kv,(i-j)) );
                     if( Double.isInfinite(tmp)&&flag ){
                         flag=false;
                     }
                }
                total += tmp /i / Math.exp( fact.lnP(seq_len,i) );
            } // see Tajima 1993
            if( Double.isNaN(total)||Double.isInfinite(total) ){ //inapplicable
                double p = ((double) ks) / ((double) len);
                double q = ((double) kv) / ((double) len);
                UBS2[seq_len][kv][ks] = - Math.log(1-2*p-q)/2;
            }else{
                UBS2[seq_len][kv][ks] = total;
            }
        }
        return UBS2[seq_len][kv][ks];
    }

 
    double biased_S2(int ks, int kv, int seq_len)  { 
        // x...ks y..kv

        UBS2 = TableMan.init_3D(seq_len, kv, ks,UBS2);  // note
        // not initialized
        if (UBS2[seq_len][kv][ks]<0){ // if not initialized
//            System.err.print("biased S ");
            double p = ((double) ks) / ((double) len);
            double q = ((double) kv) / ((double) len);
            UBS2[seq_len][kv][ks] = - Math.log(1-2*p-q)/2;
        }
        return UBS2[seq_len][kv][ks];
    }

 
    public void set_seq(String seq1, String seq2) throws ArithmeticException { 
        set = true;
        if(!isComparable(seq1,seq2)) return;
        int len = seq1.length();
        int ts = 0;
        int tv = 0;
        if (seq2.length()<len ) len = seq2.length();
        if(len<=0) return;
        set_len(len);
        for(int i=0;i<len;i++){
            char c1,c2;
            c1=seq1.charAt(i);
            c2=seq2.charAt(i);
            if ( c1!=c2 ){
                if ( isTs(c1,c2) ){
                    ts++;
                }else{
                    tv++;
                }
            }
        }
        set_PQ4(ts,tv,len);
        existence = true;

    }

    boolean isTs(char c1, char c2){
    	if( isPurine(c1) && isPurine(c2) ) return true;
    	if( isPyrimidine(c1) && isPyrimidine(c2) ) return true;
    	return false;
    }

    boolean isTv(char c1, char c2){
    	if( isPurine(c1) && isPyrimidine(c2) ) return true;
    	if( isPyrimidine(c1) && isPurine(c2) ) return true;
    	return false;
    }

    boolean isPurine(char c){
    	switch (c){
    		case 'a':
    		case 'A':
    		case 'g':
    		case 'G': return true;
    		default: 
    	}
    	return false;
    }
    
       boolean isPyrimidine(char c){
    	switch (c){
    		case 't':
    		case 'T':
    		case 'u':
    		case 'U':
    		case 'c':
    		case 'C': return true;
    		default: 
    	}
    	return false;
    }
//pq 
	
    double VP() { 
        if(!set) throw new ArithmeticException("Kimura2: not set yet!");
        return P*(1-P)/len;
    }
 
    double VQ() { 
        if(!set) throw new ArithmeticException("Kimura2: not set yet!");
        return Q*(1-Q)/len;
    }
 
    double covPQ() { 
        if(!set) throw new ArithmeticException("Kimura2: not set yet!");
        return -P*Q/((double)len); // biased!?
    }
  
//st 
	
    double VS(){ 
       if(!set) throw new ArithmeticException("Kimura2: not set yet!");
       return VP()*SP*SP + VQ()*SQ*SQ + 2*covPQ()*SQ*SP;
       // Tajima 1993
    }
 
    double VT(){ 
       if(!set) throw new ArithmeticException("Kimura2: not set yet!");
       return VQ()*TQ*TQ;
       // Tajima 1993
    }
 
    double covST(){ 
        if(!set) throw new ArithmeticException("Kimura2: not set yet!");
        return covPQ()*SP*TQ + VQ()*SQ*TQ;
    }
  
//d1d2 
	
    public double Vd1(){ 
       if(!set) throw new ArithmeticException("Kimura2: not set yet!");
       return VP()*d1P*d1P + VQ()*d1Q*d1Q + 2*covPQ()*d1P*d1Q;
       // Tajima 1993
   }
 
    public double Vd2(){ 
        if(!set) throw new ArithmeticException("Kimura2: not set yet!");
       return VQ()*d2Q*d2Q;
       // Tajima 1993
    }
 
    public double covd1d2(){ 
        if(!set) throw new ArithmeticException("Kimura2: not set yet!");
        return covPQ()*d1P*d2Q + VQ()*d1Q*d2Q;
    }
  
// k 
	
    public double k() throws ArithmeticException { 
        return (S+2*T);
    }
    
    public double dk() { 
        return (1/(2*(1-2*P-Q)))+1/(2*(1-2*Q)); // differentiate 
     }

    public double Vk() throws ArithmeticException { 
       return VS()+4*VT()+4*covST();
    }
 
    public double Vkinv() throws ArithmeticException { 
        if(Vk()>0) return 1/Vk();
//        System.err.println("here!!!");
        return -1; //illegal
    }
  
    public String name() {return "K2";} 
 
} 
  

