package io;
// Copyright Kazuharu Misawa June 13 2001
// This program is distributed under the terms of the GNU General Public License 
import java.io.*;
import java.util.*;

import node.*;


// convert newick tree (this(kind,of)data) to node
 
public class newickTree{ 

    public static node newick2tree(String newick){
        String tmp = parenthesisPolish( newick );
        String[] tmp2 = token(tmp);
        node result = pol2node(tmp2);
        return result;
    }


    public static String input(String filename) throws FileNotFoundException,IOException {
        String[] data = fileload.loadLine0(filename);
        StringBuffer result = new StringBuffer();
        for(int i=0;i<data.length;i++){
            result.append(data[i]);
        }
        return result.toString();
    }

    static String parenthesisPolish(String original){  
        // This O(n^2) algorithm can be replaced by O(n) ones.
        String tmp = original;
        while ( tmp.charAt(0) =='('  ){ // not finished
            int ptr1=0, ptr2;
            while( tmp.charAt(ptr1)!=')' ) ptr1++; //find first ')'
            ptr2=ptr1;
            while( tmp.charAt(ptr2)!='(' ) ptr2--; //move back to '('
            String newTerm = noparenthesisPolish(tmp.substring(ptr2+1,ptr1)); // within ()
            tmp = tmp.substring(0,ptr2) + newTerm + tmp.substring(ptr1+1); 
        }
        return tmp;
    }

    static String noparenthesisPolish(String original){
        boolean first = true; 
         int len = original.length();
        StringBuffer result = new StringBuffer();
        for(int ptr1=0; ptr1<len; ptr1++){
            char c = original.charAt(ptr1);
            if ( c==',' ){
                result.append('|');
                if( !first ) result.append("+|");  // skip the first one
                first=false;
            }else{
                result.append(c);
            }
        }
        result.append("|+");  // add last
        return result.toString();
    }

    public static node pol2node(String[] que){  // from RPM to tree
        int size = que.length;
        int count=0;
        LinkedList list = new LinkedList(); 
        for(int i=0;i<size; i++){
//            System.out.println(que[i]);
            char c = que[i].charAt(0);
            node tmp0;
            if(c=='+'){  // combine last two nodes
                node tmp2 = (node) list.removeLast();
                node tmp1 = (node) list.removeLast();
                tmp0 = newNode (que[i], tmp1, tmp2);
            }else{
                tmp0 = newLeaf(count,que[i]);
                count++;
            }
            list.add( tmp0 );
        }
        node result = (node) list.removeLast();
        return result;
    }


    public static String[] token(String original){  // String to String[]
        int len = original.length();
        int ptr1=0, ptr2=0;
        Vector v = new Vector();
        for(ptr1=0; ptr1<len; ptr1++){
            char c = original.charAt(ptr1);
            if(c=='|'){  
                v.addElement( original.substring(ptr2,ptr1) );
                ptr2 = ptr1+1;
            }
        }
        v.addElement( original.substring(ptr2) );
        int size = v.size();
        String[] result = new String[size];
        v.copyInto(result);
        return result;
    }

    public static node newLeaf(int No, String data){
        return new node(No, nodeName(data) , branchLength(data) );
    }

    public static node newNode(String data, node c1, node c2){
        return new node ( branchLength(data),bootstrapValue(data),c1,c2);
    }

    public static double branchLength(String data){
        int numStart=0, numEnd=0;
        for(int i=0;i<data.length();i++){
            char c = data.charAt(i);
            if (c==':') numStart = i+1;
            if ( (c=='[') ) break;
            numEnd = i;
        }
        if(numStart==0) return 0.0;
        return (Double.valueOf(data.substring(numStart,numEnd+1) )).doubleValue();
    }

    public static double bootstrapValue(String data){
        int numStart=0, numEnd=0;
        if (data.length()<=1) return 0.0;
        if( data.charAt(1)==':') {    // branch type
            for(int i=0;i<data.length();i++){
                char c = data.charAt(i);
                if (c=='[') numStart = i+1;
                if ( (c==']') || (c==',') || (c==')') ) numEnd = i;
            }
        }else{                        // node type
            numStart = 1;
            for(int i=0;i<data.length();i++){
                char c = data.charAt(i);
                if (c==':') numEnd = i;
            }
        }
        if(numStart>=numEnd) return 0.0;
        return (Double.valueOf(data.substring(numStart,numEnd) )).doubleValue();
    }

    public static String nodeName(String data){
        int nameStart=0, nameEnd=0;
        for(int i=0;i<data.length();i++){
            char c = data.charAt(i);
            if (c==':') nameEnd = i;
        }
        if(nameStart>=nameEnd) return "+";
        return data.substring(nameStart,nameEnd) ;
    }
    public static String[] convert(String[] org){
        Vector <String> v = new Vector<String> ();
        StringBuffer SB = new StringBuffer();  
        for(int i=0;i<org.length;i++){
        	int pos = org[i].indexOf(";");
        	if(pos>=0){
        		SB.append(org[i].substring(0,pos));
        		v.add(SB.toString());
        		if(pos<org[i].length()){
        			SB = new StringBuffer(org[i].substring(pos+1));
        		}else{
        			SB = new StringBuffer();
        		}
        	}else{
            	SB.append(org[i]);        		
        	}
        }
        String[] result = new String[v.size()];
        v.copyInto(result);
        return result;    
    }

} 
