package node;

// Copyright Kazuharu Misawa June 13 2001
// This program is distributed under the terms of the GNU General Public License 
 
import java.awt.*; 
import java.util.*;

 
public class node extends node0{              // parts of tree structure 
//class node {              // parts of tree structure
    public double len;      // branch length;
    public Point begin;
    public Point end;
    public int baseX;
    public int baseY;
    public String sequence;
    public String species;
    public String title;
    public double boot;
   
    int priority; 
	public static int IMPORTANT = 2;
	public static int NORMAL = 1;
	public static int CHOISE = 0;
	public static int DELETED = -1;
	public String seqType;
	
    public node(){ 
//      super();
        begin = new Point(0,0);
        end = new Point(0,0);
    }
 
    public node(int n0){ 
        super(n0);    // constructor of node0
        begin = new Point(0,0);
        end = new Point(0,0);
    }
 
    public node(double len0, node0 node1, node0 node2){ 
        super(node1, node2); // constructor of node0
        len = len0;
        begin = new Point(0,0);
        end = new Point(0,0);
    }

    public node(double len0, double boot0, node0 node1, node0 node2){ 
        super(node1, node2); // constructor of node0
        len = len0;
        boot = boot0;
        begin = new Point(0,0);
        end = new Point(0,0);
    }
 
    public node(int n0, double len0){ 
        super(n0);    // constructor of node0
        name = String.valueOf( n0 );
        len = len0;
        begin = new Point(0,0);
        end = new Point(0,0);
    }

    public node(int n0, String name0, double len0){ 
        super(n0);    // constructor of node0
        name = name0;
        len = len0;
        begin = new Point(0,0);
        end = new Point(0,0);
    }
 
 
    public node(node org){ 
        super( (node0) org );
        len = org.len;
        begin = new Point(0,0);
        end = new Point(0,0);
    }
 
    node setRoot( node root ){ 
        node tmp, newchild;
        String name = root.name;
        if (root==this){
        System.err.print(name);
        System.err.print(":");
            return this;

        }

        if (root==parent) {
//        System.err.print(name);
//        System.err.print("!");
            return this;
        }

        if (root==branch1){
            if (parent==null){
                ( (node) branch1) .len += ((node) branch2).len;
                ( (node) branch2) .len = 0.0;
//                ( (node) branch2) .len += ((node) branch1).len;
//                ( (node) branch2) .len = 100;
//                ( (node) branch1) .len = 100;
//                ( (node) branch1) .len = 0.0;
//        System.err.print("a");
                return ((node) branch2);
            }else{
                newchild = ((node) parent).setRoot(this);
                newchild.len = this.len; //this.len;
                tmp = new node( ((node) branch1).len, branch2, newchild );
//        System.err.print("b");
                return tmp;
            }
        }
        if (root==branch2){
            if (parent==null){
                ( (node) branch2) .len += ((node) branch1).len;
                ( (node) branch1) .len = 0.0;
//                ( (node) branch1) .len += ((node) branch2).len;
 //               ( (node) branch1) .len = 100;
 //               ( (node) branch2) .len = 0.0;
//        System.err.print("c");
                return ((node) branch1);
            }else{
                newchild = ((node) parent).setRoot(this);
                newchild.len = this.len; //this.len;
                tmp = new node( ((node) branch2).len, branch1, newchild );
//        System.err.print("d");
                return tmp;
            }
        }
        return null;
    }
 
    public node find( int number ){ 
        node tmp;
        if (No==number) return this;
        if (branch1!=null){
            tmp =  ( (node) branch1 ).find(number);
            if (tmp!=null) return tmp;
        }
        if (branch2!=null){
            tmp =  ( (node) branch2 ).find(number);
            if (tmp!=null) return tmp;
        }
//        System.err.print(number);
//        System.err.println(":not found!");
        return null;
    }
 
    public node setRoot(int number){  //overload 
        node tmp = find(number);
//        System.err.println(tmp.No);
//        tmp.setName("root!");
        if (tmp!=null) {
            node result = new node(-1);  // -1 means internal node
            result.parent=null;
            result.branch1 = tmp;
            result.branch2 = ( (node)tmp.parent).setRoot(tmp);
            result.recount();
            double tmplen = tmp.len;
            ((node) result.branch1).len = tmplen/2;
            ((node) result.branch2).len = tmplen/2;
            return result;
        }
        return null;
    }
    
    public node setRoot(String name){ 
    	node tmp = find(name);
        return setRoot(tmp.No);
    }

    public void setLen(double len0){ // set length_to_tip, get internal length
        double tmp =0;
        if(branch1!=null) tmp += ((node) branch1).total();
        if(branch2!=null) tmp += ((node) branch2).total();
        len = (len0-tmp/2);
    }
 

    public boolean contains(int No0){
        if( No == No0 ) return true;
        if(branch1!=null) if ( ((node) branch1).contains(No0) ) return true;
        if(branch2!=null) if ( ((node) branch2).contains(No0) ) return true;
        return false;        
    }

    public boolean containsBoth(int No1, int No2){
        if( (branch1!=null) && (branch2!=null) ){
            node b1 = (node) branch1;
            node b2 = (node) branch2;
            if ( b1.containsBoth(No1, No2) ) return true;
            if ( b2.containsBoth(No1, No2) ) return true;
            if ( b1.contains(No1) && b2.contains(No2) ) return true;
            if ( b1.contains(No2) && b2.contains(No1) ) return true;
        }
        return false;        
    }

    public double patristic(int No1, int No2){
        if (No1==No2) return 0.0;
        if( (branch1!=null) && (branch2!=null) ){
            node b1 = (node) branch1;
            node b2 = (node) branch2;
            if ( b1.containsBoth(No1, No2) ) return b1.patristic(No1, No2);
            if ( b2.containsBoth(No1, No2) ) return b2.patristic(No1, No2);
            if ( b1.contains(No2) && b2.contains(No1) ) {
                 node b3=b1; b1=b2; b2=b3;  //swap
            }
            if ( b1.contains(No1) && b2.contains(No2) ) {
                return b1.lenTo(No1) + b2.lenTo(No2);
            }
        }
        return Double.NaN;  // no distance
    }

    public void setSequence(int No0, String title0, String sp0, String sequence0){
        if ( ! contains(No0) ) return;
        if( isLeaf() ){  //itself
            title = title0; species = sp0; sequence = sequence0;
        } else {
            ( (node) branch1 ).setSequence(No0,title0,sp0,sequence0);
            ( (node) branch2 ).setSequence(No0,title0,sp0,sequence0);
        }
    }

    public void linearizedTree(double[][] mat){
        if( !isLeaf() ){  // internal node;
            ( (node) branch1 ).linearizedTree(mat);
            ( (node) branch2 ).linearizedTree(mat);

            double LAB = pairwize( (node) branch1, (node) branch2, mat);

            ( (node) branch1 ).setLen(LAB/2);
            ( (node) branch2 ).setLen(LAB/2);
        }
    }


    public double pairwize(node b1, node b2, double[][] mat){
        int[] list1 = b1.num_list();
        int[] list2 = b2.num_list();
        int count = 0;
        double total = 0;
        for(int i=0;i<list1.length;i++){
            for(int j=0;j<list2.length;j++){
                total += mat[list1[i]][list2[j]];
                count++;
            }
        }
        return total/count;
    }

    public String[][] representSequence(){
        String[][] result = new String[3][];
        if( isLeaf() ){
            result[0]=new String[1]; result[0][0] = title;
            result[1]=new String[1]; result[1][0] = sequence;
            result[2]=new String[1]; result[2][0] = species;
            return result;
        }
        node b1 = (node) branch1;
        node b2 = (node) branch2;
        String[][] result1 = b1.representSequence();
        String[][] result2 = b2.representSequence();
        int size1 = result1[0].length;
        int size2 = result2[0].length;
        String sp1    = result1[2][0];
        String sp2    = result2[2][0];
        if( (size1==1) && (size2==1) && sp1.equals(sp2) ){
            String title1 = result1[0][0];
            String title2 = result2[0][0];
            String seq1   = result1[1][0];
            String seq2   = result2[1][0];
            String tmpTitle    = title1; 
            String tmpSequence = seq1;
            int len1 = seqLenWithoutGap(seq1);
            int len2 = seqLenWithoutGap(seq2);
            if (len1<len2){
                tmpTitle = title2;
                tmpSequence = seq2;
            }
            result[0]=new String[1]; result[0][0] = tmpTitle;
            result[1]=new String[1]; result[1][0] = tmpSequence;
            result[2]=new String[1]; result[2][0] = sp1;
            return result;
        }
        int size = size1 + size2;
        result[0]=new String[size];
        result[1]=new String[size];
        result[2]=new String[size];
        for(int i=0;i<size1;i++){
             result[0][i] = result1[0][i];
             result[1][i] = result1[1][i];
             result[2][i] = result1[2][i];
        }
        for(int i=0;i<size2;i++){
            result[0][i+size1] = result2[0][i];
            result[1][i+size1] = result2[1][i];
            result[2][i+size1] = result2[2][i];
        }
        return result;
    }

    public static int seqLenWithoutGap(String seq){
        int count=0;
        for(int i=0;i<seq.length();i++){
            if(seq.charAt(i)=='-') count++;
        }
        return (seq.length()-count);
    }

    public double lenTo(int No0){
        if(No==No0) return len;
        if( (branch1!=null) && (branch2!=null) ){
            node b1 = (node) branch1;
            node b2 = (node) branch2;
            if ( b1.contains(No0) ) return len + b1.lenTo(No0); 
            if ( b2.contains(No0) ) return len + b2.lenTo(No0);
        }
        return Double.NaN;  
    }

    double total(){ 
        double tmp =0;
        if(branch1!=null) tmp += ((node) branch1).total();
        if(branch2!=null) tmp += ((node) branch2).total();
        return (len + tmp/2);
    }
 
    public void show0(){ 
        System.out.print(name);
    }
 
    public void show(){ 
        if ( (branch1!=null)&&(branch2!=null) ){
            System.out.print('(');
            ((node) branch1).show();
            System.out.print(',');
            ((node) branch2).show();
            System.out.print(')');
        } else {
            System.out.print(name);
        }
        System.out.print(':');
        System.out.print( (new Double((Math.round(len*1000)+0.0)/1000) ));
    }
 
    public void show2(){ 
        if ( (branch1!=null)&&(branch2!=null) ){
            System.out.print('(');
            ((node) branch1).show2();
            System.out.print(',');
            ((node) branch2).show2();
            System.out.print(')');
        } else {
            System.out.print(name);
        }
//        System.out.print(':');
//        System.out.print( (new Double((Math.round(len*1000)+0.0)/1000) ));
    }
    
    public void show3(){    //  trifurcating tree 
        if ( (branch1!=null)&&(branch2.branch1!=null) ){
            System.out.print('(');
            ((node) branch1).show();
            System.out.print(',');
            ((node) branch2.branch1).show();
            System.out.print(',');
            ((node) branch2.branch2) .show();
            System.out.print(')');
        } else {
            show();
        }
        System.out.println(";");
    }

    void setLine(Point rootPoint, double width, double height){
        begin.x = rootPoint.x;
        end.x   = rootPoint.x + (new Double(len*width)).intValue();
        begin.y = rootPoint.y + (new Double(height)).intValue();
        end.y   = rootPoint.y + (new Double(height)).intValue();
        if( branch1!=null ) ((node) branch1).setLine(end,width, height*0.5);
        if( branch2!=null ) ((node) branch2).setLine(end,width,-height*0.5);
    }

    public void setX(int beginX, int Xunit){
        begin.x = beginX;
        end.x   = begin.x + (int) (len*Xunit);  // width = constant
        if( branch1!=null ) ((node) branch1).setX(end.x,Xunit);
        if( branch2!=null ) ((node) branch2).setX(end.x,Xunit);
    }

    public void setBase(int X, int Y){
        baseX = X;  baseY = Y;
        if( ! isLeaf() ){
            node b1 = ((node) branch1);
            b1.setBase(X,Y);
            node b2 = ((node) branch2);
            b2.setBase(X,Y);
        }
    }

    public void setY(int[] inv, int Yunit){
        if( isLeaf() ){ // isLeaf();
            begin.y = end.y = inv[No]*Yunit;
        }else{
            node b1 = ((node) branch1);
            b1.setY(inv,Yunit);
            node b2 = ((node) branch2);
            b2.setY(inv,Yunit);
            begin.y = end.y = (b1.begin.y + b2.begin.y) / 2;
        }
    }

    public void paint(Graphics g){
        g.drawLine(begin.x+baseX,begin.y+baseY, end.x+baseX,end.y+baseY);  //tate
        if( branch1!=null && branch2!=null ){
            // yoko
            node b1 = ((node) branch1);
            node b2 = ((node) branch2);
            g.drawLine(b1.begin.x+baseX,b1.begin.y+baseY, b2.begin.x+baseX,b2.begin.y+baseY);
            if(boot>0) 
            g.drawString( (new Double(boot)).toString() ,begin.x+baseX,begin.y+baseY);
            ((node) branch1).paint(g);
            ((node) branch2).paint(g);
        }else{
            g.drawString(name,end.x+baseX,end.y+baseY);
        }
    }

    public void PostScript(){
        double PostScriptbaseX = 30;
        double PostScriptbaseY = 500;
        
        double x0b = begin.x+PostScriptbaseX;
        double y0b = -begin.y+PostScriptbaseY;
        System.out.println( moveto(x0b, y0b) );  // line begins
        double x0e = end.x+PostScriptbaseX;
        double y0e = -end.y+PostScriptbaseY;
        System.out.println( lineto(x0e, y0e) );  // line ends
        if( branch1!=null && branch2!=null ){
            // yoko
            node b1 = ((node) branch1);
                double x1 =  b1.begin.x + PostScriptbaseX;
                double y1 = -b1.begin.y + PostScriptbaseY;
            node b2 = ((node) branch2);
                double x2 =  b2.begin.x + PostScriptbaseX;
                double y2 = -b2.begin.y + PostScriptbaseY;
           System.out.println( moveto(x1, y1) );
           System.out.println( lineto(x2, y2) );
            if(boot>0) 
            System.out.println( showString( (new Double(boot)).toString() ,x0b, y0b));
            ((node) branch1).PostScript();
            ((node) branch2).PostScript();
        }else{
            System.out.println( showString( name,x0e, y0e));
        }
    }

    String moveto(double x, double y){
        return (new Double(x)).toString()+" "+(new Double(y)).toString()+" moveto";
    }

    String lineto(double x, double y){
        return (new Double(x)).toString()+" "+(new Double(y)).toString()+" lineto";
    }

    String showString(String name, double x, double y){
        String move = moveto(x,y);
        return move + " (" + name + ") show";
    }

    public double maxLen(){
        double tmp1,tmp2,max;
        tmp1 = 0;
        tmp2 = 0;
        if(branch1!=null) tmp1 = ((node) branch1).maxLen();
        if(branch2!=null) tmp2 = ((node) branch2).maxLen();
        max = (tmp1>tmp2 ? tmp1 : tmp2 );
        return (len + max);
    }

    public node copy(){ 
        node result = null;
        try{
            result = (node) clone();
            if (branch1!=null) result.branch1 = ((node) branch1).copy();
            if (branch2!=null) result.branch2 = ((node) branch2).copy();
        }catch(CloneNotSupportedException e){};
        if (branch2!=null) (result.branch1).setParent(result);
        if (branch2!=null) (result.branch2).setParent(result);
        return result;
    }
 
    public node[] all_list(){ //ׂĂOTU (leaf)̃Xg
        int n1,n2,n,i;

        node[] tmp1,tmp2,tmp;
        if( branch1 == null && branch2 == null){
             tmp = new node[1];
             tmp[0] = this;
        }else{
            tmp1 = new node[0];
            tmp2 = new node[0];
            if ( branch1 != null) tmp1 = ((node) branch1).all_list();
            if ( branch2 != null) tmp2 = ((node) branch2).all_list();
            n1 = tmp1.length;
            n2 = tmp2.length;
            n = n1+n2;
            tmp = new node[n];
            for(i=0;i<n1;i++) tmp[i]    = tmp1[i];
            for(i=0;i<n2;i++) tmp[i+n1] = tmp2[i];
        }
    	return tmp;
    }

    public node[] all_subtrees(){ 
        int n1,n2,n,i;

        node[] tmp1,tmp2,tmp;
        if( branch1 == null && branch2 == null){
             tmp = new node[1];
             tmp[0] = this;
        }else{
            tmp1 = new node[0];
            tmp2 = new node[0];
            if ( branch1 != null) tmp1 = ((node) branch1).all_subtrees();
            if ( branch2 != null) tmp2 = ((node) branch2).all_subtrees();
            n1 = tmp1.length;
            n2 = tmp2.length;
            n = n1+n2+1;
            tmp = new node[n];
            for(i=0;i<n1;i++) tmp[i]    = tmp1[i];
            for(i=0;i<n2;i++) tmp[i+n1] = tmp2[i];
            tmp[n1+n2] = this;
        }
        return tmp;
    }

    public String[] taxa(){ // taxon = a set of species 
        int n1,n2,n,i;

        String[] tmp1,tmp2,tmp;
        if( branch1 == null && branch2 == null){
             tmp = new String[1];
             tmp[0] = this.name;
        }else{
            tmp1 = new String[0];
            tmp2 = new String[0];
            if ( branch1 != null) tmp1 = ((node) branch1).taxa();
            if ( branch2 != null) tmp2 = ((node) branch2).taxa();
            n1 = tmp1.length;
            n2 = tmp2.length;
            n = n1+n2;
            tmp = new String[n];
            for(i=0;i<n1;i++) tmp[i]    = tmp1[i];
            for(i=0;i<n2;i++) tmp[i+n1] = tmp2[i];
        }
        return tmp;
    }
    
    public String[][] all_taxa(){ 
    	node[] tmp = all_subtrees();
    	int size = tmp.length;
    	String[][] result = new String[size][];
    	for(int i=0;i<size;i++){
    		result[i] = tmp[i].taxa();
    	}
    	return result;
    }
    
    int[] num_list(){ 
        node[] tmp = all_list();
        int[] result = new int[tmp.length];
        for(int i=0;i<tmp.length;i++){
            result[i] = tmp[i].No;
        }
        return result;
    }


    

    public node[] find_group(){ 
        double split;
        double unit;
        if( branch1==null || branch2==null ){
            node[] tmp = new node[1];
            tmp[0]= this;
            return tmp;
        }
        node[] tmp1;
        node[] tmp2;
        tmp1 = ((node) branch1).find_group();
        tmp2 = ((node) branch2).find_group();
        int i,j;
//      split ... more than one group
        split=0;
        for(i=0;i<tmp1.length;i++) split+= tmp1[i].len * tmp1[i].NoChildren;
        for(j=0;j<tmp2.length;j++) split+= tmp2[j].len * tmp2[j].NoChildren;
//      unit ... one group
        unit = this.len * this.NoChildren;
        if( unit >= split ){
            node[] tmp = new node[1];
            tmp[0]= this;
            return tmp;
        }else{
             int n;
             n = tmp1.length + tmp2.length;
             node[] tmp0 = new node[n];
             Vector group_tmp = new Vector();
             for(i=0;i<tmp1.length;i++) group_tmp.addElement(tmp1[i]);
             for(j=0;j<tmp2.length;j++) group_tmp.addElement(tmp2[j]);
             group_tmp.copyInto(tmp0);
             return tmp0;
        }
    }

    // 2009june.09
    public static void putName(node root, String[] name){
    	for(int i=0;i<name.length;i++){
    		node tmp = root.find(i);
    		if(tmp!=null){
    			tmp.setName(name[i]);
    		}
    	}
    }
 

    node sakanobori( node root ){ 
        node tmp, newchild;
        node b1, b2;
        if ( (root!=branch1)&&(root!=branch2) ) return null;
        b1 = (node) branch1; b2 = (node) branch2;
        if (root == branch2){ b2 = (node) branch1; b1 = (node) branch2; }
        if (parent==null){// orikaeshi, kokogamondai 
  //          System.err.print("orikaesi:" + b2.len +":" +b1.len);
           	b2.len += b1.len;
//            System.err.println(":" + b2.len +":" +b1.len);
            return b2;
        }else{
            newchild = ((node) parent).sakanobori(this); //sarani
            newchild.len = this.len; //this.len;
            tmp = new node( b1.len, b2, newchild );
    //     System.err.println("sakanobori");
            return tmp;
        }
    }


    public node find(String name0){ 
        node tmp;
        if ( name.equals(name0) ) {
        	return this;
        }
        if (branch1!=null){
            tmp =  ( (node) branch1 ).find(name0);
            if (tmp!=null) return tmp;
        }
        if (branch2!=null){
            tmp =  ( (node) branch2 ).find(name0);
            if (tmp!=null) return tmp;
        }
//      System.err.print(name0);
//      System.err.println(":not found!");
      return null;
    }
 
    public void substitute(String name0,String name1){ 
    	node tmp = find(name0);
    	tmp.setName(name1);
    }

 

    public void setName(String name1){ // set length_to_tip, get internal length
        name = name1;
    }

    public node MRCA(int No1, int No2){ // MCRC is the Most Recent Common Ancestor
    	if (isTip()) return null;
    	if ( ((node) branch1).contains(No1) && ((node) branch2).contains(No2)) return this;
    	if ( ((node) branch1).contains(No2) && ((node) branch2).contains(No1)) return this;
    	if ( ((node) branch1).containsBoth(No1,No2) ) return ((node) branch1).MRCA(No1, No2);    	
    	if ( ((node) branch2).containsBoth(No1,No2) ) return ((node) branch2).MRCA(No1, No2);
    	return null;
    }
    

    public boolean contains(String name0){
        if( name0.equals(name) ) return true;
        if(branch1!=null) if ( ((node) branch1).contains(name0) ) return true;
        if(branch2!=null) if ( ((node) branch2).contains(name0) ) return true;
        return false;        
    }


    public boolean containsBoth(String name1, String name2){
        if( (branch1!=null) && (branch2!=null) ){
            node b1 = (node) branch1;
            node b2 = (node) branch2;
            if ( b1.containsBoth(name1, name2) ) return true;
            if ( b2.containsBoth(name1, name2) ) return true;
            if ( b1.contains(name1) && b2.contains(name2) ) return true;
            if ( b1.contains(name2) && b2.contains(name1) ) return true;
        }
        return false;        
    }

    public node findMRCA(String name1, String name2){ 
    	// MRCA most recent common ancestor
    	if( !containsBoth(name1,name2) ) return null;
        node b1 = (node) branch1;
        node b2 = (node) branch2;
        if ( b1.containsBoth(name1, name2) ) return b1.findMRCA(name1, name2);
        if ( b2.containsBoth(name1, name2) ) return b2.findMRCA(name1, name2);
        return this;        
    }
    
    String autoType(String seq){
    	String result = "";
		int len=0;int count=0;
    	for(int i=0;i<seq.length();i++){
    		char c = seq.charAt(i);
    		if( (c!='-')&&(c!='*') ){
    			len++;
    			switch(c){
    				case 'A':
    				case 'a':
    				case 'T':
    				case 't':
    				case 'U':
    				case 'u':
    				case 'G':
    				case 'g':
    				case 'C':
    				case 'c': count++;    				
    			}
    		}
    		if (len>1000) break; // enough length;
    	}    	
    	if (count>len*0.8){
    		result = "DNA";
    	}else{
    		result = "Protein";
    	}
    	return result;
    }

    boolean[] hundred(){
    	int h = 100;
    	boolean[] result = new boolean[h];
    	int windowsize=sequence.length()/h;
    	for(int i=0;i<100;i++){
    		int noDataCount=0;
    		for(int j=0;j<windowsize;j++){
    			char c = sequence.charAt(i*windowsize+j);
    			if( (c=='-')||(c=='*') ){
    				noDataCount++;
    			}
    		}
    		result[i]=( noDataCount*2<windowsize);
    	}
    	return result;
    }

    public void deleteP(double p){
    	// p is proportion of non-gap characters.
    	// delete the sequence shorter than p.
    	if(isTip()){
    		int gapcount=0;
    		for(int i=0;i<sequence.length();i++){
    			char c = sequence.charAt(i);
    			if ( illegalChar(c) ){
    				gapcount++;
    			}
    		}
    		if( gapcount>(sequence.length()*(1-p)) ){
    			setPriority(DELETED);
    		}
    	}else{
    		((node) branch1).deleteP(p);
    		((node) branch2).deleteP(p);
    	}
    }

    public void setPriority(int n){
    	if(isTip()){
    		priority = n;
    	}else{
    		((node) branch1).setPriority(n);
    		((node) branch2).setPriority(n);
    	}
    }
    
    boolean illegalChar(char c){
    	if (c=='-') return true;
    	if (c=='*') return true;
    	if (c=='X') return true;
    	if ( (seqType.equals("DNA") )&&(c=='N') ) return true;
    	return false;
    }

    public String[][] dataOfLevel(int level){
        String[][] tmp1,tmp2,tmp;
        if( isTip() ){
            if (priority>=level){
                tmp = new String[3][1];
                tmp[0][0] = name;
                tmp[1][0] = sequence;
                tmp[2][0] = name;
                return tmp;
            }else{
            	return (new String[3][0]);// no data
            }
        }else{
        	tmp1 = ((node) branch1).dataOfLevel(level);
            tmp2 = ((node) branch2).dataOfLevel(level);
            int n1 = tmp1[0].length;
            int n2 = tmp2[0].length;
            int n = n1+n2;
            tmp = new String[3][n];
            for(int i=0;i<n1;i++){
            	tmp[0][i] = tmp1[0][i];
            	tmp[1][i] = tmp1[1][i];
            	tmp[2][i] = tmp1[2][i];
            }
            for(int i=0;i<n2;i++){
            	tmp[0][i+n1] = tmp2[0][i];
            	tmp[1][i+n1] = tmp2[1][i];
            	tmp[2][i+n1] = tmp2[2][i];
            }
        }
        return tmp;
    }

    public String[][][] sequenceCandidates(int level){
    	//return list of data
        String[][][] tmp1,tmp2,tmp;
        tmp = new String[0][][];
        if( isTip() ){
            if (priority>=level){
                tmp = new String[1][3][1];
                tmp[0][0][0] = name;
                tmp[0][1][0] = sequence;
                tmp[0][2][0] = name;
                return tmp;
            }else{
            	return (new String[0][][]);// no data
            }
        }else{
        	if (priority==CHOISE){
        		tmp = new String[1][][];
        		tmp[0] = dataOfLevel(level);
        	}else{
        		tmp1 = ((node) branch1).sequenceCandidates(level);
                tmp2 = ((node) branch2).sequenceCandidates(level);
                int n1 = tmp1.length;
                int n2 = tmp2.length;
                int n = n1+n2;
                tmp = new String[n][][];
                for(int i=0;i<n1;i++){
                	tmp[i] = tmp1[i];
                }
                for(int i=0;i<n2;i++){
                	tmp[i+n1] = tmp2[i];
                }
        	}
        }
        return tmp;
    }

    public void multiple(double x){ 
    	len = len*x;
        if( branch1 != null ) ((node) branch1).multiple(x);
        if( branch2 != null ) ((node) branch2).multiple(x);
        return;
    }
/*
    public String[] misawa(){//tЂ̃e[u֐Bł悭ȂB
        String[] result;
        if(isLeaf()){
            result = new String[1];
        	result[0]= name;
        }
    	String tmp1 = new String();
    	String tmp2 = new String();
    	tmp1 = tmp2 = name; // default
        if( branch1!=null ){
        	tmp1 = ((node) branch1).misawa()[0];
        }
        if( branch2!=null ){
        	tmp2 = ((node) branch2).misawa()[0];
        }
        if(tmp1==tmp2){ // same in the sense of object
            result = new String[1];
        	result[0]= name;
        }else{
            result = new String[2];
            result[0]=tmp1;
            result[1]=tmp2;
        	if( tmp1.compareTo(tmp2)>0 ){ //later
                result[0]=tmp2;
                result[1]=tmp1;
        	}
        }
        return result;
    }
*/

    public String[] list(){ // list of the OTUs of 'this' branch
    	node[] tmp = all_list();
    	String[] result = new String[tmp.length];
    	for(int i=0;i<result.length;i++){
    		result[i]=tmp[i].name;
    	}
    	Arrays.sort(result);
    	return result;
    }

    //for ManyTrees
    public String[] listOfBranches(){
       String[][] tmp=listOfList(); //qnodeList܂߂Xg
		String[] result = new String[tmp.length];
       for(int i=0;i<tmp.length;i++){
			result[i]=ListToString(tmp[i]);
		}
       Arrays.sort(result);
       return result;    	
   }
    
    public String ListToString(String[] tmp){
    	Arrays.sort(tmp);
		StringBuffer SB = new StringBuffer(tmp[0]);
		for(int j=1;j<tmp.length;j++){
			SB.append(","+tmp[j]);
		}
        return SB.toString();    	
    }    
    
    public String[][] listOfList(){
    	//̃m[h̉ɂ邷ׂĂ̕ތQ̃Xg
    	//\[gĂȂ
        String[][] result=null;
        if( branch1 == null && branch2 == null){ //leaf
        	result = new String[1][1];
        	result[0][0]=this.name;
        }else{
        	String[][] tmp1=null;
        	String[][] tmp2=null;
        	if ( branch1 != null) tmp1 = ((node) branch1).listOfList();
            if ( branch2 != null) tmp2 = ((node) branch2).listOfList();
            int n1 = tmp1.length;
            int n2 = tmp2.length;
            int n = n1+n2+1;
            result = new String[n][];
            for(int i=0;i<n1;i++) result[i]    = tmp1[i];
            for(int i=0;i<n2;i++) result[i+n1] = tmp2[i];
            result[n1+n2] = this.list();
        }
        return result;    	
    }
    public void setBootstrap(int bootstrap){
    	boot=bootstrap;
    }
    public void putListOnTable(Hashtable<String, node> table){
    	//tЂ̃Xg
    	//܂Aebranchtableɓꂽ
        if( branch1 == null && branch2 == null){ //leaf
        	table.put(this.name, this );
        }else{
        	if ( branch1 != null) ((node) branch1).putListOnTable(table);
            if ( branch2 != null) ((node) branch2).putListOnTable(table);
        	table.put(ListToString(list()), this );
        }
	}

    public void showUnrootedTree(){
    	System.out.println(unrootedTreeToString());
    }
    
    public String unrootedTreeToString(){
    	StringBuffer tmp=new StringBuffer();
        if ( (branch2!=null) ){
        	if(branch1.branch1!=null) {
        		tmp.append('(');
        		tmp.append( ((node) branch2).treeToString());
        		tmp.append(',');
        		tmp.append( ((node)((node) branch1).branch1).treeToString());
        		tmp.append(',');
        		tmp.append( ((node)((node) branch1).branch2).treeToString());
        		tmp.append(')');
        		tmp.append(';');
        	}else{
        		tmp.append('(');
        		tmp.append( ((node) branch1).treeToString());
        		tmp.append(',');
        		tmp.append( ((node) branch2).treeToString());
        		tmp.append(')');
        		tmp.append(';');        		
        	}
        } else {
            tmp.append(name);
        }
    	return tmp.toString();
    }
    
    public String treeToString(){
    	StringBuffer tmp=new StringBuffer();
        if ( (branch1!=null)&&(branch2!=null) ){
            tmp.append('(');
            tmp.append( ((node) branch1).treeToString());
            tmp.append(',');
            tmp.append( ((node) branch2).treeToString());
            tmp.append(')');
        } else {
            tmp.append(name);
        }
        tmp.append(':');
        tmp.append( Double.toString( ( (Math.round(len*1000)+0.0)/1000 ) ) );
    	return tmp.toString();
    }
    
    public String boottreeToString(){ // tree with bootstrap value
    	StringBuffer tmp=new StringBuffer();
        if ( (branch1!=null)&&(branch2!=null) ){
            tmp.append('(');
            tmp.append( ((node) branch1).boottreeToString());
            tmp.append(',');
            tmp.append( ((node) branch2).boottreeToString());
            tmp.append(')');
            tmp.append( Math.round(boot) );
            
        } else {
            tmp.append(name);
        }
        tmp.append(':');
      tmp.append( Double.toString( ( (Math.round(len*1000)+0.0)/1000 ) ) );
    	return tmp.toString();
    }

    public String unrootedBootToString(){
    	StringBuffer tmp=new StringBuffer();
        if ( (branch2!=null) ){
        	if(branch1.branch1!=null) {
        		tmp.append('(');
        		tmp.append( ((node) branch2).boottreeToString());
        		tmp.append(',');
        		tmp.append( ((node)((node) branch1).branch1).boottreeToString());
        		tmp.append(',');
        		tmp.append( ((node)((node) branch1).branch2).boottreeToString());
        		tmp.append(')');
        		tmp.append(';');
        	}else{
        		tmp.append('(');
        		tmp.append( ((node) branch1).treeToString());
        		tmp.append(',');
        		tmp.append( ((node) branch2).treeToString());
        		tmp.append(')');
        		tmp.append(';');        		
        	}
        } else {
            tmp.append(name);
        }
    	return tmp.toString();
    }
    
    public String topologyToString(){ 
    	StringBuffer tmp=new StringBuffer();
        if ( (branch1!=null)&&(branch2!=null) ){
            tmp.append('(');
            tmp.append( ((node) branch1).topologyToString());
            tmp.append(',');
            tmp.append( ((node) branch2).topologyToString());
            tmp.append(')');
        } else {
            tmp.append(name);
        }
//        tmp.append(':');
//        tmp.append( Double.toString( ( (Math.round(len*1000)+0.0)/1000 ) ) );
    	return tmp.toString();
    }
    
} 
