package node;

// Copyright Kazuharu Misawa June 13 2001
// This program is distributed under the terms of the GNU General Public License 
// seq_node is a subclass of node 
// and contains sequence data


import sequence.mutagen;
import sequence.sequence;


public class seq_node extends node{ 
    sequence seq;
    int seq_len;
    mutagen mut;

    public static seq_node create_seq_node(mutagen mut0, node org_tree, int seq_len0){ 
        if( org_tree.isLeaf() ){
            return (new seq_node(mut0, org_tree.No, org_tree.len, seq_len0 ) );
        } else {
            seq_node branch1 = create_seq_node(mut0, (node) org_tree.branch1, seq_len0);
            seq_node branch2 = create_seq_node(mut0, (node) org_tree.branch2, seq_len0);
            return (new seq_node(org_tree.len, branch1, branch2) );
        }
    }
	
    public seq_node(double len0, node0 node1, node0 node2) {
        super(len0, node1, node2); // constructor of node0
        seq = ((seq_node) node1).seq.copy();
        mut = ((seq_node) node1) .mut;
        seq_len = ((seq_node) node1) .seq_len;
    }
 
    public seq_node(mutagen mut0, int n0, double len0, int seq_len0){ 
        super(n0,len0);    // constructor of node0
        mut = mut0; seq_len = seq_len0;
        seq = new sequence(mut,seq_len);
    }
 
    public void set_rate(double u){ // set branch length; 
        for(int i=0;i<seq.len();i++) seq.set(i, u); //same rate
    }

    public void set_rate(int i, double u){ // set evolutionary rate; 
        seq.set(i,u);
        if(branch1!=null) ((seq_node) branch1).set_rate(i,u);
        if(branch2!=null) ((seq_node) branch2).set_rate(i,u);
    } 

    public void set_mut(mutagen mut0){ // set substitution pattern; 
        mut = mut0;
        seq.set_mut(mut);   // set mutation pattern
        if(branch1!=null) ((seq_node) branch1).set_mut(mut0);
        if(branch2!=null) ((seq_node) branch2).set_mut(mut0);
    }

    public void set_len(int len0,double u){ // set sequence length; 
        seq_len = len0;
        seq.set_len(seq_len,u);   // set sequence length;  
        if(branch1!=null) ((seq_node) branch1).set_len(len0,u);
        if(branch2!=null) ((seq_node) branch2).set_len(len0,u);
    }

    public void run(){
        if (parent==null){
            seq.newseq();
        } else {
            sequence org;
            org = ((seq_node) parent).seq;
            seq = org.copy();
        }
        seq.mutate( len );
        if(branch1!=null) ((seq_node) branch1).run();
        if(branch2!=null) ((seq_node) branch2).run();
    }
 
    public String toString(){ 
        return seq.toString();
    }
    
    public boolean isDNA(){
    	return mut.isDNA();
    }

    public static String[] getAllSequences(seq_node root){  
        int n = root.NoChildren; // sample size;
        String[] result = new String[n];
        for(int i=0;i<n;i++){
           node tmp = root.find(i);
           result[i] = tmp.toString();
        }
        return result;
    }

    public static String[] generateSequences(seq_node root){ 
    	// nɍ킹Ĕz
    	root.run();
    	return getAllSequences(root);
    }

} 
