package parameters;
//p[^̈߂NX
//2009/5/19
import node.*;
import java.util.Vector;
 
public class parameters{   // class for initializing parameters 
    public float u;   //average substitution rate
    public int len;   //sequence length
    public int trial; //number of trials
    public int loci;  //number of loci
    public double rho;  //transition/transversion ratio
    public double alpha; //gamma parameter among sites within one gene 
    public double alpha2; //gamma parameter among genes

    public String treetype;
    public String muttype;
    public String DNADistance;
    public String ProteinDistance;
    public String distance;
    public String weight;
    public String compareMethod; // method of tree comparison 
    public String[] fileType;
    public String[] fileName;
    public String[] OTUName;
    public String bootStrap;
    public String percentage;
//    public seq_node[] locus;
    public node input;
    public boolean inputFromFile;

//    gamrand gam;
    int inALL;
    public int[] len_arr; // length distribution

 
    public parameters(String args[]){ 
        // default
        u = 0.5F;len=100;trial=100;loci=10;rho=10;
        treetype = "A";
        alpha=Double.POSITIVE_INFINITY;
        alpha2=Double.POSITIVE_INFINITY;
        muttype = "K2";
        distance="automatic";
        DNADistance="K2";
        ProteinDistance="PO";
        weight="unweighted";
        compareMethod="exact"; // exact match
        Vector<String> ft= new Vector<String>();
        Vector<String> fn= new Vector<String>();
        inputFromFile = false;
        bootStrap="site";
        OTUName=null;
        percentage="no";
        // from args
        boolean minusOption = false;
        for(int i=0;i<args.length;i++){
            if( (args[i].charAt(0)=='-' )&&(i<args.length-1) ){
            	minusOption = true; // options are in '-something' style.
                String option =args[i];
                // sequence generator
                if(option.equals("-type"))         muttype = args[i+1];
                if(option.equals("-mutationType")) muttype = args[i+1];
                if(option.equals("-m"))            muttype = args[i+1];
                // mutation rate
                if(option.equals("-rate")) u=( new Float(args[i+1]) ).floatValue();
                if(option.equals("-mutationRate")) u=( new Float(args[i+1]) ).floatValue();
                if(option.equals("-u"))    u=( new Float(args[i+1]) ).floatValue();
                // gene length
                if(option.equals("-len")) len=( new Integer(args[i+1]) ).intValue();
                if(option.equals("-l"))   len=( new Integer(args[i+1]) ).intValue();
                // number of trials
                if(option.equals("-t"))  trial=( new Integer(args[i+1]) ).intValue();
                if(option.equals("-trial"))  trial=( new Integer(args[i+1]) ).intValue();
                if(option.equals("-numberOfTrials"))  trial=( new Integer(args[i+1]) ).intValue();
                // number of loci
                if(option.equals("-n"))     loci=( new Integer(args[i+1]) ).intValue();
                if(option.equals("-loci"))  loci=( new Integer(args[i+1]) ).intValue();
                if(option.equals("-numberOfLoci"))  loci=( new Integer(args[i+1]) ).intValue();
                // rho, ratio of transition to transversion 
                if(option.equals("-r"))   rho=( new Double(args[i+1]) ).doubleValue();
                if(option.equals("-rho")) rho=( new Double(args[i+1]) ).doubleValue();
                // alpha, the parameter of the gamma distribution
                if(option.equals("-a"))     alpha2=( new Double(args[i+1]) ).doubleValue();
                if(option.equals("-alpha")) alpha2=( new Double(args[i+1]) ).doubleValue();
                // distance method
                if(option.equals("-d"))        distance = args[i+1];
                if(option.equals("-distance")) distance = args[i+1];
                // weight method
                if(option.equals("-w"))      weight = args[i+1];
                if(option.equals("-weight")) weight = args[i+1];
                // model tree
                if(option.equals("-T"))    treetype = args[i+1];
                if(option.equals("-tree")) treetype = args[i+1];
                // output method
                if(option.equals("-o"))         compareMethod = args[i+1];
                if(option.equals("-output"))    compareMethod = args[i+1];
                if(option.equals("-comparison"))compareMethod = args[i+1];
                // bootstrap option
                if(option.equals("-b"))         bootStrap = args[i+1];
                if(option.equals("-bootstrap")) bootStrap = args[i+1];

                // bootstrap option
                if(option.equals("-percent")) percentage = args[i+1];
                if(option.equals("-percentage")) percentage = args[i+1];
                
                //input file
                if(option.equals("-file")||option.equals("-f")){
                	inputFromFile = true;
                	if(i<args.length-2){
                    	ft.add(args[i+1]);
                    	fn.add(args[i+2]);
                	}
                }
            }
        }
        if( ! minusOption ){
            if(args.length>0) muttype = args[0];
            if(args.length>1) u = ( new Float(args[1]) ).floatValue();
            if(args.length>2) len = ( new Integer(args[2]) ).intValue();
            if(args.length>3) trial = ( new Integer(args[3]) ).intValue();
            if(args.length>4) loci = ( new Integer(args[4]) ).intValue();
            if(args.length>5) rho = ( new Double(args[5]) ).doubleValue();
            if(args.length>6) treetype = args[6];
            if(args.length>7) alpha2 = ( new Double(args[7]) ).doubleValue();
        }

        if(inputFromFile){
        	loci = ft.size(); // number of data files
            fileType = new String[loci];
            fileName = new String[loci];
            ft.copyInto(fileType);
            fn.copyInto(fileName);
        }
        len_arr = new int[loci];
        for(int i=0;i<loci;i++) len_arr[i]=len;
    }

    public void set_tree(String tt){ 
        treetype=tt;
    }

    public String treeType(){  
    	return treetype;
    }

    public void set_rho(double rho0){ 
        rho = rho0;
    }
 
    public void set_mut(String muttype0){ 
        muttype = muttype0;
    }
 
    public void set_rate(double u0){ 
        u = (float) u0;
    }

    public String  mutagen(){
    	return  muttype;
    }

    public String  toString(){
    	StringBuffer result = new StringBuffer();
    	result.append("mutationPattern="); result.append(muttype); result.append("\t");
    	result.append("mutationRate=");    result.append(u);       result.append("\t");
    	result.append("len=");  result.append(len);      result.append("\t");
    	result.append("trial=");result.append(trial);    result.append("\t");
    	result.append("loci="); result.append(loci);     result.append("\t");
    	result.append("rho=");  result.append(rho);      result.append("\t");
    	result.append("tree="); result.append(treetype); result.append("\t");
    	result.append("alphaAmongSites="); result.append(alpha); result.append("\t");
    	result.append("alphaAmongGenes="); result.append(alpha2); result.append("\t");
    	result.append("distance="); result.append(distance); result.append("\t");
    	result.append("weight=");   result.append(weight); result.append("\t");
    	result.append("compareMethod="); result.append(compareMethod); result.append("\t");
        return result.toString();
    }
} 
