package sequence;

import java.lang.*; 

interface ran{   // interface of random
   public float value();
}

class ran0 implements ran{
    public float value(){
       return (float) Math.random();
    }
}

class ran1 implements ran{
    long IM, NDIV, iy, idum, iv[];
    int IA, IQ, IR, NTAB;
    double AM, EPS, RNMX;

    public ran1(){
        IA=16807;
        IM=2147483647;
        AM=(1.0/IM);
        IQ=127773;
        IR=2836;
        NTAB=32;
        NDIV=(int) (1+(IM-1)/NTAB);
        EPS=1.2e-7;
        RNMX=(1.0-EPS);

        iy=0;
        idum=0;
        iv = new long [NTAB];
    }

    public long setseed( long seed ){
        int j;
        if (seed==0) idum = 1;
        else idum = seed;
        //warm up
        for(j=1;j<=7;j++) rangen();
        // prepare random table
        for(j=0;j<NTAB;j++){
           iv[j] = rangen();
        }
        iy = iv[0];
        return iy;
    }

    public long randomize(){
       ran0 tmp = new ran0();
       setseed( (long) (tmp.value()*10000.0) );   // cast
       return(1);
    }

    public long rangen(){
        long k;
        if (idum == 0 ) randomize();  // not initialized
        k=(idum)/IQ;
        idum=IA*(idum-k*IQ)-IR*k;
        if (idum < 0) idum += IM;
        return( idum );
    }
    public float value(){  // shuffle and retrun random value (0,1)
        int j;
        float tmp;
        if( iy == 0 ) randomize();  // 'iy==0' means 'not initialized'
        j = (int) (iy / NDIV);
        iy = iv[j];
        iv[j] = rangen();
        tmp = (float) (AM*iy);
        if( tmp > RNMX ) return (float) RNMX;
        else return tmp;
    }
}
 
