package weight;


import distanceManager.mat;
import parameters.parameters;

public abstract class weight{ 
    double[] Pai; // average pairwise distance
	
    public double[] pai(mat[] m){  // sum up all lengths
        int loci = m.length;
        double[] result = new double[loci];
        for(int n=0;n<loci;n++) result[n] = m[n].pai();
        return result;
    }
 
    public double[][] d(mat[] m){ // OTU pairwise ̋̃}gbNXԂ
        Pai=null;
        int loci = m.length;
        int size=m[0].size();
    	double[][][] weight = W(m);
        double[][] result = new double[size][size];
        for(int i=0;i<size;i++){
            for(int j=0;j<size;j++){
                result[i][j] = result[j][i] = 0;
            }
        }
        for(int n=0;n<loci;n++){
            for(int i=0;i<size-1;i++){
                for(int j=i+1;j<size;j++){
                    result[i][j]+=weight[n][i][j]*m[n].distance[i][j].k();
                }
            }
        }
        for(int i=0;i<size-1;i++){
            for(int j=i+1;j<size;j++){
                result[j][i] = result[i][j];
            }
        }
        return result;
    }
	public double[][][] W(mat[] m){  // weight function
		double[][][] result = new double[m.length][][];
        int loci = m.length;
        for(int n=0;n<loci;n++){
            int size=m[n].size();
            result[n] = new double[size][size];
            for(int i=0;i<size-1;i++){
            	result[n][i][i] = 0.0;
                for(int j=i+1;j<size;j++){
                	result[n][i][j] = result[n][j][i] = 1.0;
                }
            }
        }
        return result;
	}

	public String name(){ return ("ABSTRACT"); } 
	
	public static weight chooseWeight(parameters params){
		weight result = null;
		if (params.weight.equals("TT"))     result = new TATA();
		if (params.weight.equals("TATA"))   result = new TATA();
		if (params.weight.equals("M"))      result = new TATA();
		if (params.weight.equals("LS"))     result = new leastSquare();
		if (params.weight.equals("LY"))     result = new leastSquare();
		if (params.weight.equals("Lynch"))  result = new leastSquare();
		if (params.weight.equals("L"))      result = new leastSquare();
		if (params.weight.equals("length")) result = new lengthWeight();
		if (params.weight.equals("K"))      result = new lengthWeight();
		if(result==null) result = new lengthWeight();
		return result;
	}
}
