#include <math.h>

#include "snp_Range.h"

static double Range_threshold = 3; // d.f.=1, p=1%

static double RangeSD(int sampleSize, double frequency);

int RangeUpperLimit(int sampleSize, double frequency,int haba ){
  double x = RangeSD(sampleSize,frequency);
  int n= (int) (sampleSize*frequency+x)+haba;
  if(n<sampleSize) return n;
  return sampleSize;
}

int RangeLowerLimit(int sampleSize, double frequency,int haba ){
  double x = RangeSD(sampleSize,frequency);
  int n= (int) (sampleSize*frequency-x)-haba;
  if(0<=n) return n;
  return 0;
}

static double RangeSD(int sampleSize, double frequency){
//    System.out.println(threshold*Math.sqrt(sampleSize*frequency*(1-frequency)));
  return Range_threshold*sqrt(sampleSize*frequency*(1-frequency));
}
