#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "snp_Permutation.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"
#include "snp_Random.h"

/* ԂVbt */
int PermutationCalcOmega(int len, int* result)
{
    int *flag = NULL;
    int h = 0;
    int i = 0;
    int x = 0;
    int retval = 0;

    /* flag̃m */
    flag = (int*)malloc1Dim(sizeof(int), len);
    if (NULL == flag) {
        retval = 1;
        goto finalize;
    }

    /* z0ŏ */
    for (i = 0; i < len; i++){
        result[i] = 0;
        flag[i] = 0;
    }

    /* ԂVbt */
    for (h = 0; h < len; h++){
        x = 1;
        do{
            x = (int)(myRand() * len);
            result[h] = x;
        } while(flag[x] > 0);
        flag[x]++;
    }

    /* I */
    retval = 0;

finalize:;
    /* mۂJ */
	free1Dim(flag);

    return retval;
}

/* divZ */
int PermutationCalcDi(int n, int a, int *omega, int *result)
{
    int h = 0;
    int i = 0;

    /* z0ŏ */
    for (i = 0; i< n; i++){
        result[i] = 0;
    }

    for (h = 0; h < a; h++){
        result[ omega[h] ]++;   /* 0a-1܂łcaseƂ */
    }

    return 0;
}

/* 􌻕\쐬 */
int PermutationCalcT(int *d, int *genotype, int **result, int len)
{
    int h = 0;
    int i = 0;
    int j = 0;

    /* result0ŏ */
    for (i = 0; i < ROW; i++){
        for (j = 0; j < COLUMN; j++){
            result[i][j] = 0;
        }
    }

    /* 􌻕\쐬 */
    for (h = 0; h < len; h++){
        result[ d[h] ][ genotype[h] ]++;
    }

    return 0;
}

int PermutationConditionedDi(int *genotype, int **T, int *result_type)
{
    int a1 = T[0][0], /* case */
        a2 = T[0][1],
        a = a1 + a2;
    int b1 = T[1][0], /* control */
        b2 = T[1][1],
        b = b1 + b2;
    int n1 = a1 + b1,
        n2 = a2 + b2,
        n = n1 + n2;

    //int *count = NULL;
    int *tmp = NULL;
    //int **num = NULL;
    int **shuffle = NULL;

    int h = 0;
    int i = 0;
    int j = 0;
    int tag = 0;
    int gen = 0;
    int retval = 0;

    /* tmp̃m */
    tmp = (int*)malloc1Dim(sizeof(int), VAL);
    if (NULL == tmp) {
        retval = 1;
        goto finalize;
    }
    tmp[0] = n1;
    tmp[1] = n2;
    ///* count̃m */
    //count = (int*)malloc1Dim(sizeof(int), VAL);
    //if (NULL == tmp) {
    //    retval = 2;
    //    goto finalize;
    //}
    ///* num̃m */
    //num = (int**)malloc1Dim(sizeof(int*), VAL);
    //if (NULL == num) {
    //    retval = 3;
    //    goto finalize;
    //}
    //for (i = 0; i < VAL; i++){
    //    num[i] = (int*)malloc1Dim(sizeof(int), tmp[i]);
    //    if (NULL == num[i]) {
    //        retval = 4;
    //        goto finalize;
    //    }
    //}
    /* shufflẽm */
    shuffle = (int**)malloc1Dim(sizeof(int*), VAL);
    if (NULL == shuffle) {
        retval = 5;
        goto finalize;
    }
    for (i = 0; i < VAL; i++){
        shuffle[i] = (int*)malloc1Dim(sizeof(int), tmp[i]);
        if (NULL == shuffle[i]) {
            retval = 6;
            goto finalize;
        }
    }

    //for (h = 0; h < n; h++){
    //    gen = genotype[h];
    //    num[gen][ count[gen] ] = h;
    //    count[gen]++;
    //}
    /* ̈`q^ɑΉł悤ɏIɂ͊g */

    /* ւ */
    for(gen = 0; gen < VAL; gen++){
        retval = PermutationCalcOmega(tmp[gen], shuffle[gen]);
    }

    /* ӓxɍ킹casecontrolU */
    for (gen = 0; gen < 2; gen++){
        for (h = 0; h < tmp[gen]; h++){
            tag = shuffle[gen][h];
            if (h < T[0][gen]){
                result_type[tag] = 0;
            }
            else{
                result_type[tag] = 1;
            }
        }
    }

    /* I */
    retval = 0;

finalize:;
    /* mۂJ */
	free1Dim(tmp);
	//free1Dim(count);
    //freeInt2Dim(num, VAL);
    freeInt2Dim(shuffle, VAL);

	return retval;
}
