#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "snp_RAT.h"

int main(int argc, char* argv[])
{
    InputRAT inputRAT={"", "", "", 0, "", 0, 0, 0, 0};

    if(argc != 10){
        printf("[usage]main.exe [InputFile1] [InputFile2] [OutputFile] [AreaFileType] [BlockAreaFile] [Score] [Generation] [Burnin] [dataType] \n");
        return 255;
    }
    strcpy(inputRAT.inputFile1, argv[1]);
    strcpy(inputRAT.inputFile2, argv[2]);
    strcpy(inputRAT.outputFile1, argv[3]);
    inputRAT.areaFileType = atoi(argv[4]);
    strcpy(inputRAT.blockAreaFile, argv[5]);
    inputRAT.score = atoi(argv[6]);
    inputRAT.gen = atol(argv[7]);
    inputRAT.burnin = atol(argv[8]);
    inputRAT.dataType = atoi(argv[9]);

    /* XRAvZ@̎w */
    iWay = inputRAT.score;

    /* ֐ */
    initMyRand();

    /* RATPermutations */
    MainProgramRAT(&inputRAT);

}


/* RATPermutations */
void MainProgramRAT(InputRAT *inputRAT)
{
    int retval = 0;
    int flag = 0;
    long i = 0;
	long j = 0;
    long fileLine1 = 0; /* ̓t@Cicasej̃C */
    long fileLine2 = 0; /* ̓t@Cicontorlj̃C */
    long areaFileLine = 0; /* haplotypeubN̈wt@C̃C */
    long a = 0;         /* number of haplotype copies (=sequences) in case */
    long b = 0;         /* number of haplotype copies (=sequences) in control */
    long n = 0;
    long dataNum;       /* caseAcontrolf[^̑SNP */
    long jStart = 0;    /* haplotypeubN̍ŏSNP */
    long jEnd = 0;      /* haplotypeubN̍ŌSNP */
    long blockNum = 0;  /* haplotypeubN */
    long gen = 0;
    long startPos = 0;
    long endPos = 0;
    double S = 0;

    int **T = NULL;             /* 􌻕\ */
    int *populationType = NULL;
    long *blockArea = NULL;     /* ehaplotypeubN̈i[ */
    long *linkSNPNum = NULL;    /* ehaplotypeubNSNP */
    long *linkSNPStart = NULL;  /* ehaplotypeubN̍ŏSNP */
    long *maxScoreIndex = NULL; /* ehaplotypeubÑXRAől̍ */
    double *Sobs = NULL;        /* ehaplotypeubÑXRAől */
    double *p = NULL;

    FILE *fpCase = NULL;    /* ́icasejt@C|C^ */
    FILE *fpCntl = NULL;    /* ́icontroljt@C|C^ */
    FILE *fpOut = NULL;     /* o̓t@C|C^ */
    FILE *fpArea = NULL;    /* haplotypeubN̈wt@C|C^ */

    char *caseData = NULL;      /* Tvf[^icaseji[p */
    char *controlData = NULL;   /* Tvf[^icontrolji[p */

    SnpData *snpTmpData1 = NULL;
    SnpData *snpTmpData2 = NULL;
    SnpData *snpData1 = NULL;
    SnpData *snpData2 = NULL;

    gen = inputRAT->gen;

    /* t@CI[v */
    retval = InputFileOpen(&fpCase, inputRAT->inputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpCntl, inputRAT->inputFile2);
    if (retval != 0){
        goto finalize;
    }
    retval = OutputFileOpen(&fpOut, inputRAT->outputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpArea, inputRAT->blockAreaFile);
    if (retval != 0){
        goto finalize;
    }

/****************************************************************/
/* f[^                                                   */
/****************************************************************/
 
    /* haplotypeubN̈wt@C̃C擾 */
    areaFileLine = DataReaderCountFileLine(fpArea);
    /* haplotypeubN̈i[pz̃m */
    blockArea = (long*)malloc1Dim(sizeof(long), areaFileLine);
    if (NULL == blockArea){ goto finalize; }
    /* t@C|C^擪ɖ߂ */
    fseek(fpArea, 0L, SEEK_SET);
    /* haplotypeubN̈zɎ߂ */
    DataReaderSetHaplotypeBlockArea(fpArea, blockArea);

    /* ̓t@C̃C擾 */
    fileLine1 = DataReaderCountFileLine(fpCase);
    fileLine2 = DataReaderCountFileLine(fpCntl);

    /* t@C|C^擪ɖ߂ */
    fseek(fpCase, 0L, SEEK_SET);
    fseek(fpCntl, 0L, SEEK_SET);

    /* f[^ꎞi[p\̂̃m */
    snpTmpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine1);
    if (NULL == snpTmpData1){ goto finalize; }
    snpTmpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine2);
    if (NULL == snpTmpData2){ goto finalize; }

    /* f[^t@Cǂݍݍ\̂Ɏ߂ */
    DataReaderSetAllData(fpCase, snpTmpData1, fileLine1, inputRAT->dataType);
    DataReaderSetAllData(fpCntl, snpTmpData2, fileLine2, inputRAT->dataType);

    /* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
    /* MPI_Bcast̉񐔂炷߂ɃTvf[^͕ʔzicaseData, controlDatajŕێ */
    dataNum = DataReaderMakeParallelData(snpTmpData1, snpTmpData2, fileLine1, fileLine2, &snpData1, &snpData2, &caseData, &controlData);

    /* gpȂz̃J */
    /* \SnpDataõJ */
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    snpTmpData1 = NULL;
    snpTmpData2 = NULL;

    /* ̓f[^̃Tv擾 */
    a = snpData1[0].dataNum;
    b = snpData2[0].dataNum;
    n = a + b;

    /* \SnpDataɃTvf[^Rs[ */
    DataReaderDataCopyToSnpData(snpData1, caseData, dataNum, a);
    DataReaderDataCopyToSnpData(snpData2, controlData, dataNum, b);

/****************************************************************/
/* m                                                   */
/****************************************************************/

    /* haplotypeubN */
    if (inputRAT->areaFileType == 0){
        blockNum = areaFileLine - 1;
    }
    else {
        /* haplotypeubŇvZ */
        if (blockArea[0] > dataNum){
            blockNum = 1;
            blockArea[1] = dataNum; /* linkSNPNum̒lf[^ɂȂ */
        }
        else{
            blockNum = (dataNum - (blockArea[0] - blockArea[1]) ) / blockArea[1];
        }
    }
    /* ehaplotypeubN̈SNPi[pz̃m */
    linkSNPNum = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPNum){ goto finalize; }
    /* ehaplotypeubN̈̍ŏSNPʊi[pz̃m */
    linkSNPStart = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPStart){ goto finalize; }

    /* ehaplotypeubN̈ɊYSNPf[^ */
    if (inputRAT->areaFileType == 0){
        for (i = 0; i < blockNum; i++){ /* Ä̏dꍇl */
            startPos = blockArea[i];
            endPos = blockArea[i+1];
            flag = 0;
            /* ̓f[^̓|WVŃ\[gĂƉ */
            for (j = 0; j < dataNum; j++){
                if (startPos <= snpData1[j].pos){
                    if (snpData1[j].pos < endPos){
                        /* ̈SNPJEg */
                        linkSNPNum[i]++;
                        /* ̈̍ŏSNPʂێ */
                        if (0 == flag ){
                            linkSNPStart[i] = j;
                            flag = 1;
                        }
                    }
                    /* ȍ~ÄɊYf[^͏oȂ̂Ŏ̃ubN𒲂ׂ */
                    else {
                        break;
                    }
                }
            }
        }
    }
     else {
        for (i = 0; i < blockNum; i++){
            linkSNPNum[i] = blockArea[0];
            linkSNPStart[i] = i * blockArea[1];
        }
    }

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }
    /* populationTypẽm */
    populationType = (int*)malloc1Dim(sizeof(int), a + b);
    if (NULL == populationType) { goto finalize; }
    /* HaplotypeubÑXRAől̍ʂ̃m */
    maxScoreIndex = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == maxScoreIndex) { goto finalize; }
    /* HaplotypeubÑXRAől̃m */
    Sobs = (double*)malloc1Dim(sizeof(double), blockNum);
    if (NULL == Sobs) { goto finalize; }
    /* p̃m */
    p = (double*)malloc1Dim(sizeof(double), blockNum);
    if (NULL == p) { goto finalize; }

/****************************************************************/
/* 菈                                                     */
/****************************************************************/

    /* haplotypeubNPʂŃ[v */
    jStart = 0;
    for (i = 0; i < blockNum; i++){
        jStart = linkSNPStart[i];
        jEnd = jStart + linkSNPNum[i];
        /* ehaplotypeubNŃ[v */
        for (j = jStart; j < jEnd; j++){
            /* ϑl􌻕\쐬 */
            DataReaderPopulationType(&snpData1[j], &snpData2[j], populationType);
            DataReaderMakeTableDi(&snpData1[j], &snpData2[j], populationType, T);
            /* XRAvZ@XRAvZ0ɂȂĂ܂ꍇ-1Ԃ */
            S = TableCalcScore(T);
            /* őXRA肷 */
            if (S > Sobs[i]){
                Sobs[i] = S;
                maxScoreIndex[i] = j;
            }
        }

        /* RATPermutations */
        if (Sobs[i] > 0.0) {
            p[i] = RATExecute(snpData1, snpData2, Sobs[i], a, b, jStart, jEnd, gen, inputRAT->burnin);
        }
    }

/****************************************************************/
/* 茋ʏo                                                 */
/****************************************************************/

    fprintf(fpOut, "CaseData    = %s\n", inputRAT->inputFile1);
    fprintf(fpOut, "ControlData = %s\n", inputRAT->inputFile2);
    fprintf(fpOut, "Genoration  = %ld\n", inputRAT->gen);
    fprintf(fpOut, "BlockArea\tSNPNum\trsNumber\tPosition\tScore\tP\n");
    if (inputRAT->areaFileType == 0){
        for (i = 0; i < blockNum; i++){
            if (Sobs[i] != 0){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t%.3e\n", 
                    blockArea[i],
                    blockArea[i+1],
                    linkSNPNum[i],
                    snpData1[ maxScoreIndex[i] ].rsNumber,
                    snpData1[ maxScoreIndex[i] ].pos,
                    Sobs[i],
                    p[i]);
            }
            else {
                fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                    blockArea[i],
                    blockArea[i+1],
                    linkSNPNum[i]);
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            if (Sobs[i] != 0){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t%.3e\n", 
                    snpData1[ linkSNPStart[i] ].pos,
                    snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                    linkSNPNum[i],
                    snpData1[ maxScoreIndex[i] ].rsNumber,
                    snpData1[ maxScoreIndex[i] ].pos,
                    Sobs[i],
                    p[i]);
            }
            else {
                fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                    snpData1[ linkSNPStart[i] ].pos,
                    snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                    linkSNPNum[i]);
            }
        }
    }

/****************************************************************/
/* I                                                     */
/****************************************************************/

finalize:;
    /* t@CN[Y */
    FileClose(fpCase);
    FileClose(fpCntl);
    FileClose(fpOut);
    FileClose(fpArea);
    /* mۂJ */
    free1Dim(blockArea);
    free1Dim(linkSNPNum);
    free1Dim(linkSNPStart);
    freeInt2Dim(T, ROW);
    free1Dim(populationType);
    free1Dim(maxScoreIndex);
    free1Dim(Sobs);
    free1Dim(p);
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    free1Dim(caseData);
    free1Dim(controlData);
    free1Dim(snpData1);
    free1Dim(snpData2);

    return;
}

/* RATPermutations */
double RATExecute(SnpData *snpData1, SnpData *snpData2, double Sobs, long a, long b, long jStart, long jEnd, long gen, long burnin)
{
    long h = 0;
    long i = 0;
    long j = 0;
    long m = 0;
    long n = 0;
    long gen2 = 0;
    double sumOfQj = 0;
    double sumOfinvQj = 0;
    double S = 0;
    double Srat = 0;
    double F = 0;
    double logF = 0;
    double Qvalue = 0;
    double result = 0;
    SnpTable T;

    int *type = NULL;
    int *di = NULL;
    int **genotype = NULL;
    int ***Tj = NULL;
    double *Sj = NULL;
    double *numberOfDiInHj = NULL;

    n = a + b;
    m = jEnd - jStart;

    /* significantł͂ȂꍇAI */
    if ( Sobs < 3.84){
        printf("P > 0.05\n");
        return 0.05;
    }

    /* log e[u쐬 */
    FactorialSetFactorial(n);

    /* typẽm */
    type = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == type) { goto finalize; }
    /* dĩm */
    di = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == di) { goto finalize; }
    /* genotypẽm */
    genotype = (int**)mallocInt2Dim(m, n);
    if (NULL == genotype) { goto finalize; }
    /* Tj̃m */
    Tj = (int***)mallocInt3Dim(m, ROW, COLUMN);
    if (NULL == Tj) { goto finalize; }
    /* Sj̃m */
    Sj = (double*)malloc1Dim(sizeof(double), m);
    if (NULL == Sj) { goto finalize; }
    /* numberOfDiInHj̃m */
    numberOfDiInHj = (double*)malloc1Dim(sizeof(double), m);
    if (NULL == numberOfDiInHj) { goto finalize; }
         
    for (j = jStart; j < jEnd; j++){
        /* ϑl􌻕\쐬 */
        DataReaderPopulationType(&snpData1[j], &snpData2[j], type);
        DataReaderMakeTableDi(&snpData1[j], &snpData2[j], type, Tj[i]);
        /* genotypevZ */
        RATGenotype(&snpData1[j], &snpData2[j], genotype[i]);
        i++;
    }

    for (i = 0; i < m; i++){
        TableMakeTableIntArray(&T, Tj[i]);
        numberOfDiInHj[i] = RATNumberOfDiInHj(T, Sobs);
        sumOfQj += numberOfDiInHj[i];
        /* \tablẽJ */
        TableFinalTable(&T);
    }

    for (h= 0; h < burnin; h++){
        for (i = 0; i < m; i++){
            TableMakeTableIntArray(&T, Tj[i]);
            RATAlgorithmB(T, Sobs, Tj[i]);
            /* \tablẽJ */
            TableFinalTable(&T);
        }
    }

    for (h = 0; h < gen; h++){
        j = RATAlgorithmA(numberOfDiInHj, m);
        TableMakeTableIntArray(&T, Tj[j]);
        RATAlgorithmB(T, S, Tj[j]);
        RATAlgorithmC(genotype[j], Tj[j], di);
        Qvalue = RATCalcQvalue(genotype, di, Sobs, n, m);
        if (Qvalue != 0){
            sumOfinvQj += 1 / Qvalue;
            gen2++;
        }
        /* \tablẽJ */
        TableFinalTable(&T);
    }

    //F = FactorialGetCombination(n, a);
    logF = FactorialGetLogCombination(n, a);
    if (0 == gen2){
        result = -1;
    }
    else{
        result = exp( log(sumOfQj) + log(sumOfinvQj) - log(gen2) - logF );
        //result = sumOfQj * sumOfinvQj / gen2 / F;
    }


finalize:;
    /* mۂJ */
    free1Dim(type);
	freeInt2Dim(genotype, m);
    freeInt3Dim(Tj, m, ROW);
    free1Dim(Sj);
    free1Dim(numberOfDiInHj);
    free1Dim(di);
    /* loge[uNA */
    FactorialDeleteFactorial();
    /* \tablẽJ */
    TableFinalTable(&T);

    return result;
}

/* }[J[jnumberOfDiInHj[j]ɔႵmŕԂ */
long RATAlgorithmA(double *numberOfDiInHj, long m)
{
    long j = 0;
    double p = 0;
    double sumOfNumberOfHj = 0;


    for (j = 0; j < m; j++){
        sumOfNumberOfHj += numberOfDiInHj[j];
    }
    p = sumOfNumberOfHj * myRand();  

    for (j = 0; j < m; j++){
        if (p < numberOfDiInHj[j]){
            return j;
        }
        p -= numberOfDiInHj[j];
    }

    return 0;
}

/* 􉽕zɏ]MCMCŁAȑÕe[v玟̃e[v쐬 */
int RATAlgorithmB(SnpTable T, double Score, int **table)
{
    if (FLAG_TRUE == TableTwoParts(T, Score)){
        TableMarkov2(T, Score, table);
    }
    else{
        TableMarkov1(T, Score, table);
    }

    return 0;
}

/* 􌻕\Ppermutation event𓙊mŒo */
int RATAlgorithmC(int *genotype, int **table, int *di)
{
    PermutationConditionedDi(genotype, table, di);
    return 0;
}

/* Q̒lvZ */
long RATCalcQvalue(int **genotype, int *di, double Sobs, long n, long dataNum)
{
    int retval = 0;
    long j = 0;
    long result = 0;
    double S = 0;
    int **T = NULL;

    /* T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }

    for (j = 0; j < dataNum; j++){
        retval = PermutationCalcT(di, genotype[j], T, n);
        S = TableCalcScore(T);
        if (S >= Sobs){
            result++;
        }      	
    }

finalize:;
    /* mۂJ */
    freeInt2Dim(T, ROW);

    return result;
}

double RATNumberOfDiInHj(SnpTable table, double Sobs)
{
    double result = 0;
    int l = 0;
    int u = 0;
    int retval = 0;
    int **T = NULL;

    int i = 0;
    int a1 = 0;

    /* T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T) {
        retval = 1;
        goto finalize;
    }

    l = TableCalcL(table);
    u = TableCalcU(table);

    for (a1 = l; a1 <= u; a1++){
        retval = TableNewTable(table, a1, T);
        if (FLAG_TRUE == TableInCj(Sobs, T, ROW, COLUMN)){
            result += TableCalcMu(T);
        }
    }

finalize:;
    /* mۂJ */
    freeInt2Dim(T, ROW);

    return result;
}

/* genotypevZ */
int RATGenotype(SnpData *snpData1, SnpData *snpData2, int *genotype)
{
    long h = 0;
    long a = 0;
    long b = 0;
    char reference = 0;

    int *genotype1 = NULL;
    int *genotype2 = NULL;

    a = snpData1->dataNum;
    b = snpData2->dataNum;
   
    /* genotype1̃m */
    genotype1 = (int*)malloc1Dim(sizeof(int), a);
    if (NULL == genotype1) { goto finalize; }
    /* genotype2̃m */
    genotype2 = (int*)malloc1Dim(sizeof(int), b);
    if (NULL == genotype2) { goto finalize; }

    /* Qƕ */
    reference = DataReaderMaximumNuc(snpData1);

    /* genotypevZ */
    DataReaderCalcGenotype(snpData1, reference, genotype1);
    DataReaderCalcGenotype(snpData2, reference, genotype2);
    for (h = 0; h < a; h++){
        genotype[h] = genotype1[h];
    }
    for (h = 0; h < b; h++){
        genotype[h + a] = genotype2[h];
    }

finalize:;
    /* mۂJ */
    free1Dim(genotype1);
    free1Dim(genotype2);

    return 0;
}
