#include <stdio.h>
//#include <stdlib.h>
//#include <math.h>

#include "snp_MemoryControl.h"
#include "snp_Config.h"
#include "snp_Chi.h"

static int **signiDiff = NULL;
static int size = 0;
static double threshold = 6.634896712;  /* ͂ŔCӂ̒lw肷悤ɕύX\L */
static double sigma = 3.5;  /* ͂ŔCӂ̒lw肷悤ɕύX\L */


int ChiMain()
{
    int sampleSize = 200;
    int i = 0;
    int j = 0;

    ChiSetSigniDiff(sampleSize);

    for (i = 1; i < 100; i++){
        for (j = 1; j < 100; j++){
            printf("%d\n", ChiIsSigniDiff2Int(i, j));
        }
        printf("\n");
    }
    
    ChiDeleteSigniDiff();
	
    return 0;
}

int ChiSetSigniDiff(int sampleSize)
{
    int i = 0;
    int j = 0;

    size = sampleSize;

    signiDiff = (int**)mallocInt2Dim(size + 1, size + 1);
    if (NULL == signiDiff){
        return 1;
    }

    for (i = 1; i < size + 1; i++){
        for (j = 1; j < size + 1; j++){
            if (ChiSquare1(i, size - i, j, size - j) > threshold){
                signiDiff[i][j] = FLAG_TRUE;
            }
            else{
                signiDiff[i][j] = FLAG_FALSE;
            }
        }
    }

    return 0;
}

void ChiDeleteSigniDiff()
{
    freeInt2Dim(signiDiff, size + 1);
    return;
}

int ChiIsSigniDiff(int **data, int length)
{
    int i = 0;

    for (i = 0; i < length; i++){
        if (ChiTest(size, data[0][i], data[1][i]) == 1){
            return FLAG_TRUE;
        }
    }
    return FLAG_FALSE;
}

int ChiIsSigniDiff2Int(int i, int j)
{
    return !(signiDiff[i][j]);
}

double ChiSquare1(int A, int B, int C, int D)
{
    double a = 0;
    double b = 0;
    double c = 0;
    double d = 0;
    double N = 0;
    double chi2 = 0;
    double denominator = 0;

    a = A;
    b = B;
    c = C;
    d = D;
    N = a + b + c + d;

    /* 0̂߁Aꂪ0Ȃ-1Ԃ */
    denominator = (a + c) * (b + d) * (a + b) * (c + d);
    if (0 == denominator){
        return -1;
    }

    chi2 = ( (a * d - b * c) * (a * d - b * c) * N) / denominator;

    return chi2;
}

int ChiTest(int sampleSize, int patient, int control)
{
    double chi2 = 0;

    chi2 = ChiSquare1(patient, sampleSize - patient, control, sampleSize - control);
    if (chi2 > threshold){
        return 1;
    }
    return 0;
}

int ChiTest4Int(int A, int B, int C, int D)
{
    double chi2 = 0;

    chi2 = ChiSquare1(A, B, C, D);
    if (chi2 > threshold){
        return 1;
    }
    return 0;
}

